/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.organization.core.organization;

import com.covisint.core.http.service.core.AbstractRealmScopedResource;
import com.covisint.core.http.service.core.ResourceReference;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NotEmpty;
import com.covisint.core.support.constraint.Nullable;
import com.covisint.core.support.constraint.Searchable;
import com.covisint.platform.legacy.address.Address;
import com.covisint.platform.legacy.phone.Phones;
import com.covisint.platform.organization.core.organization.Status;
import com.google.common.base.Objects;

public class Organization
extends AbstractRealmScopedResource<Organization> {
    private static final long serialVersionUID = 1742842823432L;
    private long organizationId;
    private Status status;
    @Searchable
    private ResourceReference parentOrganization;
    @Searchable
    private ResourceReference rootOrganization;
    @Searchable
    private String name;
    private Address address;
    private Phones phones;
    private String email;
    private String url;
    private String authDomain;
    private String organizationType;
    private String organizationSubtype;
    private String accountNumber;
    private String externalCode;
    private String duns;
    private String classification;
    private boolean publicOrganization;
    private ResourceReference passwordPolicy;
    private ResourceReference authenticationPolicy;

    public long getOrganizationId() {
        return this.organizationId;
    }

    @Nonnull
    public Organization setOrganizationId(long id) {
        this.organizationId = id;
        return this;
    }

    public Status getStatus() {
        return this.status;
    }

    @Nonnull
    public Organization setStatus(@Nullable Status newStatus) {
        this.status = newStatus;
        return this;
    }

    public ResourceReference getParentOrganization() {
        return this.parentOrganization;
    }

    @Nonnull
    public Organization setParentOrganization(@Nullable ResourceReference newParentOrganization) {
        this.parentOrganization = newParentOrganization;
        return this;
    }

    @Nonnull
    public Organization setParentOrganizationId(@Nonnull @NotEmpty String id) {
        this.parentOrganization = new ResourceReference(id, "organization");
        return this;
    }

    public ResourceReference getRootOrganization() {
        return this.rootOrganization;
    }

    @Nonnull
    public Organization setRootOrganization(@Nonnull ResourceReference newRootOrganization) {
        this.rootOrganization = newRootOrganization;
        return this;
    }

    @Nonnull
    public Organization setRootOrganizationId(@Nonnull @NotEmpty String id) {
        this.rootOrganization = new ResourceReference(id, "organization");
        return this;
    }

    public String getName() {
        return this.name;
    }

    @Nonnull
    public Organization setName(@Nonnull @NotEmpty String newName) {
        this.name = newName;
        return this;
    }

    public Address getAddress() {
        return this.address;
    }

    @Nonnull
    public Organization setAddress(@Nonnull Address newAddress) {
        this.address = newAddress;
        return this;
    }

    public Phones getPhones() {
        return this.phones;
    }

    @Nonnull
    public Organization setPhones(@Nullable Phones newPhones) {
        this.phones = newPhones;
        return this;
    }

    public String getEmail() {
        return this.email;
    }

    @Nonnull
    public Organization setEmail(@Nullable String newEmail) {
        this.email = newEmail;
        return this;
    }

    public String getUrl() {
        return this.url;
    }

    @Nonnull
    public Organization setUrl(@Nullable String newUrl) {
        this.url = newUrl;
        return this;
    }

    public String getAuthDomain() {
        return this.authDomain;
    }

    @Nonnull
    public Organization setAuthDomain(@Nullable String newAuthDomain) {
        this.authDomain = newAuthDomain;
        return this;
    }

    public String getOrganizationType() {
        return this.organizationType;
    }

    @Nonnull
    public Organization setOrganizationType(@Nonnull @NotEmpty String newOrganizationType) {
        this.organizationType = newOrganizationType;
        return this;
    }

    public String getOrganizationSubtype() {
        return this.organizationSubtype;
    }

    @Nonnull
    public Organization setOrganizationSubtype(@Nullable String newOrganizationSubtype) {
        this.organizationSubtype = newOrganizationSubtype;
        return this;
    }

    public String getAccountNumber() {
        return this.accountNumber;
    }

    @Nonnull
    public Organization setAccountNumber(@Nullable String newAccountNumber) {
        this.accountNumber = newAccountNumber;
        return this;
    }

    public String getExternalCode() {
        return this.externalCode;
    }

    @Nonnull
    public Organization setExternalCode(@Nullable String newExternalCode) {
        this.externalCode = newExternalCode;
        return this;
    }

    public String getDuns() {
        return this.duns;
    }

    @Nonnull
    public Organization setDuns(@Nullable String newDuns) {
        this.duns = newDuns;
        return this;
    }

    public String getClassification() {
        return this.classification;
    }

    @Nonnull
    public Organization setClassification(@Nullable String newClassification) {
        this.classification = newClassification;
        return this;
    }

    public boolean isPublicOrganization() {
        return this.publicOrganization;
    }

    @Nonnull
    public Organization setPublicOrganization(@Nullable boolean newPublicOrganization) {
        this.publicOrganization = newPublicOrganization;
        return this;
    }

    public ResourceReference getPasswordPolicy() {
        return this.passwordPolicy;
    }

    @Nonnull
    public Organization setPasswordPolicy(@Nullable ResourceReference newPasswordPolicy) {
        this.passwordPolicy = newPasswordPolicy;
        return this;
    }

    @Nonnull
    public Organization setPasswordPolicyId(@Nonnull @NotEmpty String id) {
        this.passwordPolicy = new ResourceReference(id, "passwordPolicy");
        return this;
    }

    public ResourceReference getAuthenticationPolicy() {
        return this.authenticationPolicy;
    }

    @Nonnull
    public Organization setAuthenticationPolicy(@Nullable ResourceReference newAuthenticationPolicy) {
        this.authenticationPolicy = newAuthenticationPolicy;
        return this;
    }

    @Nonnull
    public Organization setAuthenticationPolicyId(@Nonnull @NotEmpty String id) {
        this.authenticationPolicy = new ResourceReference(id, "authenticationPolicy");
        return this;
    }

    public final int hashCode() {
        return this.getResourceIdentityHashCode();
    }

    public final boolean equals(@Nonnull Object obj) {
        return this.isResourceIdentityEqual(Organization.class, obj);
    }

    @Nonnull
    @NotEmpty
    public final String toString() {
        return this.populateToStringHelper(Objects.toStringHelper((Object)((Object)this))).add("organizationId", this.organizationId).add("status", (Object)this.status).add("parentOrganization", (Object)this.parentOrganization).add("rootOrganization", (Object)this.rootOrganization).add("name", (Object)this.name).add("address", (Object)this.address).add("phones", (Object)this.phones).add("email", (Object)this.email).add("url", (Object)this.url).add("authDomain", (Object)this.authDomain).add("organizationType", (Object)this.organizationType).add("organizationSubtype", (Object)this.organizationSubtype).add("accountNumber", (Object)this.accountNumber).add("externalCode", (Object)this.externalCode).add("duns", (Object)this.duns).add("classification", (Object)this.classification).add("public", this.publicOrganization).add("passwordPolicy", (Object)this.passwordPolicy).add("authenticationPolicy", (Object)this.authenticationPolicy).toString();
    }
}

