/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.organization.core.organization.io.json;

import com.covisint.core.http.service.core.AbstractRealmScopedResource;
import com.covisint.core.http.service.core.io.jsonp.AbstractRealmScopedResourceWriter;
import com.covisint.core.http.service.core.io.jsonp.JsonpSupport;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.Nullable;
import com.covisint.core.support.primitive.StringSupport;
import com.covisint.platform.legacy.address.Address;
import com.covisint.platform.legacy.phone.Phones;
import com.covisint.platform.organization.core.organization.Organization;
import com.covisint.platform.organization.core.organization.Status;
import com.covisint.platform.organization.core.organization.io.json.SupportedMediaType;
import com.google.common.net.MediaType;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;

public class OrganizationWriter
extends AbstractRealmScopedResourceWriter<Organization> {
    @Nonnull
    private JsonArray writeStreets(@Nonnull Address address) {
        JsonArrayBuilder streets = Json.createArrayBuilder();
        String street = address.getAddress1();
        if (street != null) {
            streets.add(street);
        }
        if ((street = address.getAddress2()) != null) {
            streets.add(street);
        }
        if ((street = address.getAddress3()) != null) {
            streets.add(street);
        }
        return streets.build();
    }

    @Nullable
    private JsonArray writeAddresses(@Nonnull Address address) {
        if (address != null) {
            JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
            JsonObjectBuilder addressBuilder = Json.createObjectBuilder();
            JsonArray streets = this.writeStreets(address);
            if (!streets.isEmpty()) {
                addressBuilder.add("streets", (JsonValue)streets);
            }
            JsonpSupport.addPropertyIfNonnullValue((JsonObjectBuilder)addressBuilder, (String)"city", (String)address.getCity());
            JsonpSupport.addPropertyIfNonnullValue((JsonObjectBuilder)addressBuilder, (String)"state", (String)address.getState());
            JsonpSupport.addPropertyIfNonnullValue((JsonObjectBuilder)addressBuilder, (String)"country", (String)address.getCountry());
            JsonpSupport.addPropertyIfNonnullValue((JsonObjectBuilder)addressBuilder, (String)"postal", (String)address.getPostal());
            arrayBuilder.add((JsonValue)addressBuilder.build());
            JsonArray jsonArray = arrayBuilder.build();
            if (!jsonArray.isEmpty()) {
                return jsonArray;
            }
        }
        return null;
    }

    private JsonArray writePhones(@Nonnull Organization organization) {
        Phones phones = organization.getPhones();
        if (phones != null) {
            JsonArrayBuilder phonesJson = Json.createArrayBuilder();
            for (String phoneType : Phones.SUPPORTED_PHONE_TYPES) {
                String number = phones.getByType(phoneType);
                if (StringSupport.trimOrNull((String)number) == null) continue;
                JsonObjectBuilder builder = Json.createObjectBuilder();
                builder.add("type", phoneType).add("number", number);
                phonesJson.add((JsonValue)builder.build());
            }
            JsonArray phonesArray = phonesJson.build();
            if (!phonesArray.isEmpty()) {
                return phonesArray;
            }
        }
        return null;
    }

    @Nonnull
    protected final JsonObjectBuilder writeResource(@Nonnull MediaType mediaType, @Nonnull Organization organization) {
        JsonArray phones;
        JsonObjectBuilder builder = super.writeResource(mediaType, (AbstractRealmScopedResource)organization);
        Status status = organization.getStatus();
        if (status != null) {
            builder.add("status", status.name().toLowerCase());
        }
        if (organization.getParentOrganization() != null) {
            this.writeResourceReference("parentOrganization", organization.getParentOrganization(), builder);
        }
        if (organization.getRootOrganization() != null) {
            this.writeResourceReference("rootOrganization", organization.getRootOrganization(), builder);
        }
        JsonpSupport.addPropertyIfNonnullValue((JsonObjectBuilder)builder, (String)"name", (String)organization.getName());
        JsonArray addresses = this.writeAddresses(organization.getAddress());
        if (addresses != null) {
            builder.add("addresses", (JsonValue)addresses);
        }
        if ((phones = this.writePhones(organization)) != null) {
            builder.add("phones", (JsonValue)phones);
        }
        JsonpSupport.addPropertyIfNonnullValue((JsonObjectBuilder)builder, (String)"email", (String)organization.getEmail());
        JsonpSupport.addPropertyIfNonnullValue((JsonObjectBuilder)builder, (String)"url", (String)organization.getUrl());
        JsonpSupport.addPropertyIfNonnullValue((JsonObjectBuilder)builder, (String)"authDomain", (String)organization.getAuthDomain());
        JsonpSupport.addPropertyIfNonnullValue((JsonObjectBuilder)builder, (String)"organizationType", (String)organization.getOrganizationType());
        JsonpSupport.addPropertyIfNonnullValue((JsonObjectBuilder)builder, (String)"organizationSubtype", (String)organization.getOrganizationSubtype());
        JsonpSupport.addPropertyIfNonnullValue((JsonObjectBuilder)builder, (String)"accountNumber", (String)organization.getAccountNumber());
        JsonpSupport.addPropertyIfNonnullValue((JsonObjectBuilder)builder, (String)"externalCode", (String)organization.getExternalCode());
        JsonpSupport.addPropertyIfNonnullValue((JsonObjectBuilder)builder, (String)"duns", (String)organization.getDuns());
        JsonpSupport.addPropertyIfNonnullValue((JsonObjectBuilder)builder, (String)"classification", (String)organization.getClassification());
        builder.add("public", organization.isPublicOrganization());
        if (organization.getPasswordPolicy() != null) {
            this.writeResourceReference("passwordPolicy", organization.getPasswordPolicy(), builder);
        }
        if (organization.getAuthenticationPolicy() != null) {
            this.writeResourceReference("authenticationPolicy", organization.getAuthenticationPolicy(), builder);
        }
        return builder;
    }

    @Nonnull
    public final Class<Organization> getResourceType() {
        return Organization.class;
    }

    public final boolean isWritable(@Nonnull Class clazz, @Nonnull MediaType mediaType) {
        return SupportedMediaType.ORGANIZATION_MT.value().equals(mediaType.withoutParameters().toString());
    }
}

