/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.core.http.service.client;

import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NotEmpty;
import com.google.common.cache.Cache;
import com.google.common.util.concurrent.FutureCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CachingFutureCallback<T>
implements FutureCallback<T> {
    private final Logger log = LoggerFactory.getLogger(CachingFutureCallback.class);
    private final Cache cache;
    private final String cacheKey;

    public CachingFutureCallback(@Nonnull Cache newCache, @Nonnull @NotEmpty String newCacheKey) {
        this.cache = newCache;
        this.cacheKey = newCacheKey;
    }

    public void onSuccess(T result) {
        if (result == null) {
            return;
        }
        this.cache.put((Object)this.cacheKey, result);
        this.log.debug("Successfully retrieved and cached resource for key {}", (Object)this.cacheKey);
    }

    public void onFailure(Throwable t) {
    }
}

