/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.legacy;

import com.covisint.core.http.service.core.InvocationContext;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NotEmpty;
import com.covisint.core.support.primitive.StringSupport;
import com.covisint.platform.legacy.RealmLookupService;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;

public final class DataSourceRouter
extends AbstractRoutingDataSource {
    private static final Logger LOG = LoggerFactory.getLogger(DataSourceRouter.class);
    private final RealmLookupService realmService;
    private final Map<Object, Object> datasources;
    private final Map<String, String> realmDataSourceIdentifier = new HashMap<String, String>();

    public DataSourceRouter(@Nonnull RealmLookupService service, @Nonnull @NotEmpty Map<String, DataSource> newDatasources, @Nonnull DataSource defaultDatasource) {
        if (newDatasources.isEmpty()) {
            throw new IllegalArgumentException("No datasources provided.");
        }
        this.setDefaultTargetDataSource(defaultDatasource);
        this.datasources = new HashMap<Object, Object>();
        for (Map.Entry<String, DataSource> ds : newDatasources.entrySet()) {
            this.datasources.put(ds.getKey().toLowerCase(), ds.getValue());
        }
        this.setTargetDataSources(this.datasources);
        this.realmService = service;
    }

    protected Object determineCurrentLookupKey() {
        String datasourceName = "default";
        String realmId = InvocationContext.getRealmId();
        if (StringSupport.trimOrNull((String)realmId) == null) {
            return datasourceName;
        }
        if (this.realmDataSourceIdentifier.containsKey(realmId)) {
            return this.realmDataSourceIdentifier.get(realmId);
        }
        LOG.debug("Getting datasource name for realm {}", (Object)realmId);
        try {
            datasourceName = this.realmService.determineDatasourceName();
        }
        catch (IllegalArgumentException e) {
            LOG.debug("No datasource defined for realm {}. ", (Object)realmId);
        }
        this.realmDataSourceIdentifier.put(realmId, datasourceName);
        LOG.debug("returning datasource {} defined for realm {}", (Object)datasourceName, (Object)realmId);
        return datasourceName;
    }
}

