/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.legacy.address;

import com.covisint.core.http.service.core.Resource;
import com.covisint.core.support.primitive.StringSupport;
import com.covisint.platform.legacy.address.CountrySupport;
import com.google.common.base.Objects;
import java.io.Serializable;

public final class Address
implements Serializable {
    private static final long serialVersionUID = -4934576488555259804L;
    private String address1;
    private String address2;
    private String address3;
    private String city;
    private String state;
    private String postal;
    private String countryCode;
    private Resource owner;

    public String getAddress1() {
        return this.address1;
    }

    public Address setAddress1(String newAddress1) {
        this.address1 = StringSupport.trimOrNull((String)newAddress1);
        return this;
    }

    public String getAddress2() {
        return this.address2;
    }

    public Address setAddress2(String newAddress2) {
        this.address2 = StringSupport.trimOrNull((String)newAddress2);
        return this;
    }

    public String getAddress3() {
        return this.address3;
    }

    public Address setAddress3(String newAddress3) {
        this.address3 = StringSupport.trimOrNull((String)newAddress3);
        return this;
    }

    public String getCity() {
        return this.city;
    }

    public Address setCity(String newCity) {
        this.city = StringSupport.trimOrNull((String)newCity);
        return this;
    }

    public String getState() {
        return this.state;
    }

    public Address setState(String newState) {
        this.state = StringSupport.trimOrNull((String)newState);
        return this;
    }

    public String getPostal() {
        return this.postal;
    }

    public Address setPostal(String newPostal) {
        this.postal = StringSupport.trimOrNull((String)newPostal);
        return this;
    }

    public String getCountry() {
        return this.countryCode;
    }

    public Resource getOwner() {
        return this.owner;
    }

    public Address setOwner(Resource parent) {
        this.owner = parent;
        return this;
    }

    public Address setCountry(String newCountryCode) {
        if (StringSupport.trimOrNull((String)newCountryCode) != null && !CountrySupport.isValidCountryCode(newCountryCode)) {
            throw new IllegalArgumentException("Invalid ISO 3166 country code: " + newCountryCode);
        }
        this.countryCode = StringSupport.trimOrNull((String)newCountryCode);
        return this;
    }

    public String toString() {
        Objects.ToStringHelper builder = Objects.toStringHelper((Object)this).add("address1", (Object)this.address1).add("address2", (Object)this.address2).add("address3", (Object)this.address3).add("city", (Object)this.city).add("state", (Object)this.state).add("postal", (Object)this.postal).add("country", (Object)this.countryCode);
        if (this.owner != null) {
            builder.add("owner", (Object)this.owner.getId());
        }
        return builder.toString();
    }
}

