/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.legacy.cleartrust;

import com.covisint.core.support.constraint.Constraints;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NotEmpty;
import com.covisint.platform.legacy.cleartrust.ClearTrustApiException;
import com.covisint.platform.legacy.cleartrust.ClearTrustFacade;
import java.io.IOException;
import java.net.URL;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sirrus.api.client.APIException;
import sirrus.api.client.APIServerProxy;
import sirrus.api.client.DuplicateObjectException;
import sirrus.api.client.IAPIObject;
import sirrus.api.client.IAdministrativeGroup;
import sirrus.api.client.IApplication;
import sirrus.api.client.IApplicationURL;
import sirrus.api.client.IChild;
import sirrus.api.client.IEntity;
import sirrus.api.client.IExplicitEntitlement;
import sirrus.api.client.IGroup;
import sirrus.api.client.ISparseData;
import sirrus.api.client.IUser;
import sirrus.api.client.IWebServer;
import sirrus.api.client.ObjectNotFoundException;
import sirrus.api.client.criteria.StringCriterion;
import sirrus.api.client.search.IAdministrativeGroupSearch;
import sirrus.api.client.search.IApplicationSearch;
import sirrus.api.client.search.IGroupSearch;
import sirrus.api.client.search.IUserSearch;
import sirrus.connect.ConnectionDescriptor;

public final class ClearTrustFacadeImpl
implements ClearTrustFacade {
    private static final int RETRY_ATTEMPTS = 2;
    private final Logger log = LoggerFactory.getLogger(ClearTrustFacadeImpl.class);
    private String host;
    private int port;
    private String adminUser;
    private String adminPassword;
    private String adminGroup;
    private String adminRole;

    private APIServerProxy getServerProxy() throws ClearTrustApiException {
        APIServerProxy server;
        try {
            server = new APIServerProxy(new ConnectionDescriptor(this.host, this.port, 0));
            server.connect(this.adminUser, this.adminPassword, this.adminGroup, this.adminRole);
        }
        catch (IOException | APIException e) {
            throw new ClearTrustApiException(e);
        }
        this.log.debug("Successfully created connection to cleartrust API server.");
        return server;
    }

    private void saveUserWithRetryOnDuplicateError(IUser user, int retryAttempts) throws IOException, APIException {
        try {
            this.log.debug("Attempting to save ClearTrust entry for user with id {} ", (Object)user.getName());
            user.save();
            this.log.debug("Saved ClearTrust entry for user with id {}", (Object)user.getName());
        }
        catch (DuplicateObjectException e) {
            if (retryAttempts == 0) {
                this.log.warn("Unable to save ClearTrust entry with id {}", (Object)user.getName());
                throw e;
            }
            this.log.debug("Encountered DuplicateObjectException when attempting to save user with id {} ", (Object)user.getName());
            this.saveUserWithRetryOnDuplicateError(user, retryAttempts - 1);
        }
    }

    private IAdministrativeGroup getAdminGroup(StringCriterion criterion, APIServerProxy server) throws IOException, APIException {
        IAdministrativeGroupSearch searchAdminGroup = server.searchAdministrativeGroupObjects();
        searchAdminGroup.setNameCriterion(criterion);
        ISparseData groups = searchAdminGroup.search();
        return (IAdministrativeGroup)groups.getByIndex(0);
    }

    private void setAdminGroupOnUser(IUser user, long organizationId, String realm, APIServerProxy server) throws IOException, APIException {
        IAdministrativeGroup group = null;
        try {
            this.log.debug("Finding administrative group for company {}  ", (Object)organizationId);
            group = this.getAdminGroup(new StringCriterion(7, " (" + organizationId + ")"), server);
        }
        catch (ObjectNotFoundException e) {
            this.log.debug("Administrative group for company {} not found  ", (Object)organizationId);
            this.log.debug("Setting administrative group for realm {}", (Object)realm);
            group = this.getAdminGroup(new StringCriterion(2, realm), server);
        }
        user.setAdministrativeGroup(group);
        this.saveUserWithRetryOnDuplicateError(user, 2);
        this.log.debug("User {} added to administrative group {}", (Object)user.getName(), (Object)group.getQualifiedName());
    }

    private void addUserToGroup(IUser user, IGroup group) throws IOException, APIException {
        try {
            group.addChild((IChild)user);
            group.save();
            this.log.debug("Succesfully added user {} to group {}", (Object)user.getName(), (Object)group.getName());
        }
        catch (DuplicateObjectException e) {
            this.log.debug("Already found  user {} in group {}.  No further action to take.", (Object)user.getName(), (Object)group.getName());
        }
    }

    private void addUserToOrganization(long orgId, IUser user, APIServerProxy server) throws IOException, APIException {
        IGroup group = this.searchGroup(new StringCriterion(7, " (" + orgId + ")"), server);
        this.log.debug("Adding user {} to organization group {}", (Object)user.getName(), (Object)group.getName());
        this.addUserToGroup(user, group);
    }

    private IGroup searchGroup(StringCriterion criterion, APIServerProxy server) throws IOException, APIException {
        IGroupSearch searchGroup = server.searchGroupObjects();
        searchGroup.setNameCriterion(criterion);
        ISparseData groups = searchGroup.search();
        try {
            return (IGroup)groups.getByIndex(0);
        }
        catch (ObjectNotFoundException e) {
            this.log.error("Group not found in cleartrust: {}", (Object)criterion.getStringValue());
            throw e;
        }
    }

    private IUser searchUser(String personId, APIServerProxy server) throws IOException, APIException {
        IUserSearch userSearch = server.searchUserObjects();
        userSearch.setUserIDCriterion(new StringCriterion(2, personId));
        ISparseData users = userSearch.search();
        try {
            return (IUser)users.getByIndex(0);
        }
        catch (ObjectNotFoundException e) {
            this.log.error("User not found in cleartrust: {}", (Object)personId);
            throw e;
        }
    }

    private IApplication searchApplication(long serviceId, APIServerProxy server) throws IOException, APIException {
        IApplication application;
        this.log.debug("Searching for cleartrust application with service id {}", (Object)serviceId);
        IApplicationSearch searchApplication = server.searchApplicationObjects();
        searchApplication.setNameCriterion(new StringCriterion(7, " (Service " + serviceId + ")"));
        ISparseData applications = searchApplication.search();
        try {
            application = (IApplication)applications.getByIndex(0);
        }
        catch (ObjectNotFoundException e) {
            this.log.error("Application not found in cleartrust: {}", (Object)serviceId);
            throw e;
        }
        this.log.debug("Found cleartrust application with service id {}: {}", (Object)serviceId, (Object)application.getName());
        return application;
    }

    private IWebServer searchWebServer(URL protectedUrl, APIServerProxy server) throws APIException, IOException {
        IAPIObject[] allWebServers;
        String protectedHost = protectedUrl.getHost();
        this.log.debug("Searching for web server protecting host {}", (Object)protectedHost);
        for (IAPIObject item : allWebServers = server.searchWebServerObjects().search().getByRange(0, Integer.MAX_VALUE)) {
            IWebServer webServer = (IWebServer)item;
            if (!webServer.getHostname().equals(protectedHost)) continue;
            this.log.debug("Found web server protecting host: {}", (Object)webServer.getName());
            return webServer;
        }
        return null;
    }

    private IApplication createApplication(String name, APIServerProxy server) throws APIException, IOException {
        String version = "1.0";
        IApplication application = server.createApplication(name, "Automatically created application", "1.0");
        boolean isAllowBeforeDeny = false;
        application.setPolicyAllowBeforeDeny(false);
        application.setPublic(false);
        application.save();
        this.log.debug("Created application {}", (Object)name);
        return application;
    }

    private IWebServer createWebServer(String name, URL protectedUrl, boolean isPublic, APIServerProxy server) throws APIException, IOException {
        String scheme = protectedUrl.getProtocol();
        String serverHost = protectedUrl.getHost();
        int serverPort = protectedUrl.getPort();
        IWebServer webServer = server.createWebServer(name, "Automatically created web server", "Apache", String.format("%s://%s", scheme, serverHost), serverPort, isPublic);
        webServer.save();
        this.log.debug("Created web server {} for host {}", (Object)name, (Object)protectedUrl.getAuthority());
        return webServer;
    }

    private void createApplicationUrl(IApplication application, IWebServer webServer, URL protectedUrl, APIServerProxy server) throws APIException, IOException {
        String protectedPath = protectedUrl.getPath();
        if (protectedPath.isEmpty()) {
            protectedPath = "/*";
        } else if (protectedPath.endsWith("/")) {
            protectedPath = protectedPath + "*";
        }
        this.log.debug("Creating application URL for path {}", (Object)protectedPath);
        try {
            IApplicationURL appURL = server.createAppURL(application, webServer, protectedPath, "Automatically created application url");
            appURL.setPolicyAllowBeforeDeny(false);
            appURL.save();
            this.log.debug("Created application URL {} for service {}", (Object)protectedPath, (Object)application.getName());
        }
        catch (DuplicateObjectException e) {
            this.log.warn("Application URL {} for web server {} and host {} already exists.  Nothing left to do.", new Object[]{protectedUrl, application.getName(), webServer.getHostname()});
        }
    }

    private void disconnect(APIServerProxy server) {
        try {
            server.disconnect();
        }
        catch (IOException e) {
            this.log.warn("Could not disconnect from server.", (Throwable)e);
        }
    }

    @Override
    public void createUser(@Nonnull @NotEmpty String id, @Nonnull @NotEmpty String realmCode, @Nonnull @NotEmpty String email, @Nonnull @NotEmpty String givenName, @Nonnull @NotEmpty String surname, long rootOrganizationId, long personOrganizationId) throws ClearTrustApiException {
        this.log.debug("creating ClearTrust entry for person with id  {}  and root org {}", (Object)id, (Object)rootOrganizationId);
        APIServerProxy server = this.getServerProxy();
        try {
            IUser user = this.searchUser(id, server);
            this.log.info("CT user {} found.", (Object)user.getName());
            this.disconnect(server);
            return;
        }
        catch (ObjectNotFoundException ex) {
            this.log.info("No user found. Creating one.");
        }
        catch (IOException | APIException e) {
            throw new ClearTrustApiException(e);
        }
        DateTime timeAfterYears = new DateTime().plusYears(25);
        boolean publicUser = false;
        boolean administrativelyLocked = true;
        IUser user = server.createUser(id, false, new DateTime().toDate(), timeAfterYears.toDate(), givenName, surname, email, id, true);
        try {
            this.setAdminGroupOnUser(user, rootOrganizationId, realmCode, server);
            this.addUserToOrganization(personOrganizationId, user, server);
        }
        catch (IOException | APIException e) {
            this.log.warn("Error setting administrative group for user.", e);
            this.log.info("Deleting user in CT: {}", (Object)id);
            try {
                user.delete();
            }
            catch (IOException | APIException e1) {
                this.log.error("Could not rollback user creation after error.", e1);
            }
            throw new ClearTrustApiException(e);
        }
        finally {
            this.disconnect(server);
        }
        this.log.debug("Successfully created person {} in Cleartrust", (Object)id);
    }

    @Override
    public void unlockUser(@Nonnull @NotEmpty String personId) throws ClearTrustApiException {
        APIServerProxy server = this.getServerProxy();
        try {
            IUser user = this.searchUser(personId, server);
            if (!user.isAdminLockedout()) {
                this.log.debug("User {} is not administratively locked in cleartrust.  Not continuing to unlock.");
                return;
            }
            user.setAdminLockedout(false);
            this.saveUserWithRetryOnDuplicateError(user, 2);
        }
        catch (IOException | APIException e) {
            throw new ClearTrustApiException(e);
        }
        finally {
            this.disconnect(server);
        }
    }

    @Override
    public void lockUser(@Nonnull @NotEmpty String personId) throws ClearTrustApiException {
        APIServerProxy server = this.getServerProxy();
        try {
            IUser user = this.searchUser(personId, server);
            if (user.isAdminLockedout()) {
                this.log.debug("User {} is already administratively locked in cleartrust.  Not continuing to lock.");
                return;
            }
            user.setAdminLockedout(true);
            this.saveUserWithRetryOnDuplicateError(user, 2);
        }
        catch (IOException | APIException e) {
            throw new ClearTrustApiException(e);
        }
        finally {
            this.disconnect(server);
        }
    }

    @Override
    public void addPackageToUser(@Nonnull @NotEmpty String personId, long packageId) throws ClearTrustApiException {
        APIServerProxy server = this.getServerProxy();
        try {
            IGroup group = this.searchGroup(new StringCriterion(7, " (Package " + packageId + ")"), server);
            IUser user = this.searchUser(personId, server);
            this.addUserToGroup(user, group);
        }
        catch (IOException | APIException e) {
            throw new ClearTrustApiException(e);
        }
        finally {
            this.disconnect(server);
        }
    }

    @Override
    public void createPackage(long packageId, @Nonnull @NotEmpty String packageName) throws ClearTrustApiException {
        String groupName = packageName + " (Package " + packageId + ")";
        this.log.debug("Creating cleartrust group {}", (Object)groupName);
        APIServerProxy server = this.getServerProxy();
        try {
            boolean publicGroup = false;
            IGroup group = server.createGroup(groupName, false, "Automatically created package.");
            group.save();
            this.log.debug("Successfully created group {}", (Object)group.getName());
        }
        catch (DuplicateObjectException e) {
            this.log.warn("Group {} already exists.  Cannot proceed.", (Object)groupName);
            return;
        }
        catch (IOException | APIException e) {
            throw new ClearTrustApiException(e);
        }
        finally {
            this.disconnect(server);
        }
    }

    @Override
    public void createService(long serviceId, @Nonnull @NotEmpty String serviceName, @Nonnull URL protectedUrl) throws ClearTrustApiException {
        APIServerProxy server = this.getServerProxy();
        String applicationName = serviceName + " (Service " + serviceId + ")";
        try {
            IApplication application = this.createApplication(applicationName, server);
            IWebServer webServer = this.searchWebServer(protectedUrl, server);
            if (webServer == null) {
                boolean isPublic = false;
                webServer = this.createWebServer(applicationName, protectedUrl, false, server);
            }
            this.createApplicationUrl(application, webServer, protectedUrl, server);
        }
        catch (DuplicateObjectException e) {
            this.log.warn("Service {} already exists.  Cannot proceed.", (Object)applicationName);
            return;
        }
        catch (IOException | APIException e) {
            throw new ClearTrustApiException(e);
        }
        finally {
            this.disconnect(server);
        }
    }

    @Override
    public void addServiceToPackage(long packageId, long serviceId) throws ClearTrustApiException {
        APIServerProxy server = this.getServerProxy();
        try {
            IGroup group = this.searchGroup(new StringCriterion(7, " (Package " + packageId + ")"), server);
            IApplication application = this.searchApplication(serviceId, server);
            boolean accessible = true;
            this.log.debug("Creating application {} for group {}", (Object)application.getName(), (Object)group.getName());
            server.createExplicitEntitlement((IEntity)group, application, true);
            this.log.debug("Created application {} for group {}", (Object)application.getName(), (Object)group.getName());
        }
        catch (ObjectNotFoundException e) {
            this.log.warn("Either group {} or application {} was not found in cleartrust.", (Object)packageId, (Object)serviceId);
            return;
        }
        catch (DuplicateObjectException e) {
            this.log.warn("The group already has this entitlement.  No further action to take.");
            return;
        }
        catch (IOException | APIException e) {
            throw new ClearTrustApiException(e);
        }
        finally {
            this.disconnect(server);
        }
    }

    @Override
    public void removeServiceFromPackage(long packageId, long serviceId) throws ClearTrustApiException {
        APIServerProxy server = this.getServerProxy();
        try {
            IExplicitEntitlement ent;
            IGroup group = this.searchGroup(new StringCriterion(7, " (Package " + packageId + ")"), server);
            IApplication application = this.searchApplication(serviceId, server);
            this.log.debug("Deleting entitlement {} from group {}", (Object)application.getName(), (Object)group.getName());
            try {
                ent = group.getExplicitEntitlement(application);
            }
            catch (ObjectNotFoundException e) {
                this.log.warn("The group doesn't have this entitlement.  No further action to take.");
                this.disconnect(server);
                return;
            }
            ent.delete();
            this.log.debug("Deleted entitlement {} from group {}", (Object)application.getName(), (Object)group.getName());
        }
        catch (ObjectNotFoundException e) {
            this.log.warn("Either group {} or application {} was not found in cleartrust.", (Object)packageId, (Object)serviceId);
            return;
        }
        catch (IOException | APIException e) {
            throw new ClearTrustApiException(e);
        }
        finally {
            this.disconnect(server);
        }
    }

    @Override
    public void createOrganization(long organizationId, String organizationName) throws ClearTrustApiException {
        String groupName = organizationName + " (" + organizationId + ")";
        APIServerProxy server = this.getServerProxy();
        try {
            this.log.debug("Creating cleartrust administrative group {}", (Object)groupName);
            boolean defaultPrivate = false;
            boolean forcedPasswordExpiry = false;
            IAdministrativeGroup administrativeGroup = server.createAdministrativeGroup(groupName, "Automatically created administration group", false, false, "Relaxed Policy");
            administrativeGroup.save();
            this.log.debug("Successfully created Administrator group {}", (Object)administrativeGroup.getName());
            this.log.debug("Creating cleartrust group {}", (Object)groupName);
            boolean publicGroup = false;
            IGroup group = server.createGroup(groupName, false, "Automatically created group.");
            group.setAdministrativeGroup(administrativeGroup);
            group.save();
            this.log.debug("Successfully created group {}", (Object)group.getName());
        }
        catch (DuplicateObjectException e) {
            this.log.warn("Group {} already exists.  Cannot proceed.", (Object)groupName);
            return;
        }
        catch (IOException | APIException e) {
            throw new ClearTrustApiException(e);
        }
        finally {
            this.disconnect(server);
        }
    }

    @Override
    public void addWebServer(long serviceId, String serverName, URL protectedUrl) throws ClearTrustApiException {
        this.log.debug("Creating cleartrust web server: {} ", (Object)serverName);
        APIServerProxy server = this.getServerProxy();
        try {
            IApplication app = this.searchApplication(serviceId, server);
            IWebServer webServer = this.searchWebServer(protectedUrl, server);
            if (webServer == null) {
                webServer = this.createWebServer(serverName, protectedUrl, false, server);
            }
            this.createApplicationUrl(app, webServer, protectedUrl, server);
        }
        catch (ObjectNotFoundException e) {
            this.log.error("No application found for ID: {}", (Object)serviceId);
            throw new ClearTrustApiException(e);
        }
        catch (IOException | APIException e) {
            throw new ClearTrustApiException(e);
        }
        finally {
            this.disconnect(server);
        }
    }

    @Override
    public void setNewPassword(@Nonnull @NotEmpty String userId, @Nonnull @NotEmpty String newPassword) throws ClearTrustApiException {
        this.log.debug("Setting new cleartrust password for user {}.", (Object)userId);
        APIServerProxy server = this.getServerProxy();
        try {
            server.connect(this.adminUser, this.adminPassword, this.adminGroup, this.adminRole);
            server.setPassword(userId, newPassword);
            this.log.debug("Cleartrust password successfully updated for user {}.", (Object)userId);
        }
        catch (IOException | APIException e) {
            throw new ClearTrustApiException(e);
        }
        finally {
            this.disconnect(server);
        }
    }

    @Override
    public void updatePassword(@Nonnull @NotEmpty String userId, @Nonnull @NotEmpty String currentPassword, @Nonnull @NotEmpty String newPassword) throws ClearTrustApiException {
        this.log.debug("Updating cleartrust password for user {}.", (Object)userId);
        APIServerProxy server = this.getServerProxy();
        try {
            server.connect(this.adminUser, this.adminPassword, this.adminGroup, this.adminRole);
            server.resetPassword(userId, currentPassword, newPassword);
            this.log.debug("Cleartrust password successfully updated for user {}.", (Object)userId);
        }
        catch (IOException | APIException e) {
            throw new ClearTrustApiException(e);
        }
        finally {
            this.disconnect(server);
        }
    }

    public void setHost(@Nonnull @NotEmpty String newHost) {
        this.host = newHost;
    }

    public void setPort(int newPort) {
        Constraints.isGreaterThan((long)0L, (long)newPort, (String)"Invalid port.");
        Constraints.isLessThan((long)65536L, (long)newPort, (String)"Invalid port.");
        this.port = newPort;
    }

    public void setAdminUser(@Nonnull @NotEmpty String newAdminUser) {
        this.adminUser = newAdminUser;
    }

    public void setAdminPassword(@Nonnull @NotEmpty String newAdminPassword) {
        this.adminPassword = newAdminPassword;
    }

    public void setAdminGroup(@Nonnull @NotEmpty String newAdminGroup) {
        this.adminGroup = newAdminGroup;
    }

    public void setAdminRole(@Nonnull @NotEmpty String newAdminRole) {
        this.adminRole = newAdminRole;
    }
}

