/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.legacy.event;

import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NotEmpty;
import com.covisint.platform.legacy.event.EventLog;
import com.covisint.platform.legacy.event.SystemEventDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.core.support.JdbcDaoSupport;

public final class SystemEventJdbcDao
extends JdbcDaoSupport
implements SystemEventDao {
    private static final String SQL_GET_NEXT_SEQUENCE_VALUE = "SELECT CRS_MASTER_SEQ.NEXTVAL FROM DUAL";
    private static final String SQL_INSERT_SYSTEM_EVENT = "INSERT INTO EVENT_LOG (SYSTEM_EVENT_ID, SYSTEM_EVENT_TYPE, SYSTEM_EVENT_DATE, ACTOR_USER_ID, SUBJECT_USER_ID, SUBJECT_ORG_ID, NOTES, REALM_CODE) VALUES (:systemEventId, :systemEventType, sysdate, (SELECT NVL(MAX(USER_ID),0) FROM USERS WHERE GBL_COV_USER_ID = :requestorId), (SELECT USER_ID FROM USERS WHERE GBL_COV_USER_ID = :subjectUserId), (SELECT ORGANIZATION_ID FROM ORGANIZATIONS WHERE GBL_COV_ORG_ID = :subjectOrgId), (SELECT CASE WHEN COUNT(USER_ID) = 0 THEN CONCAT(CONCAT(:notes, ', Original Actor: '), :requestorId)  ELSE :notes END AS USER_ID FROM USERS WHERE GBL_COV_USER_ID = :requestorId), :realmCode)";
    private final Logger log = LoggerFactory.getLogger(SystemEventJdbcDao.class);

    @Nonnull
    protected Long getNextSequenceValue() {
        return (Long)this.getJdbcTemplate().queryForObject(SQL_GET_NEXT_SEQUENCE_VALUE, Long.class);
    }

    @Override
    @Nonnull
    @NotEmpty
    public String insertSystemEvent(@Nonnull EventLog eventLog) {
        this.log.debug("Creating a new system event in the system with type: {}", (Object)eventLog.getSystemEventType());
        Long systemEventId = this.getNextSequenceValue();
        MapSqlParameterSource args = new MapSqlParameterSource();
        args.addValue("systemEventId", (Object)systemEventId);
        args.addValue("systemEventType", (Object)eventLog.getSystemEventType());
        args.addValue("requestorId", (Object)eventLog.getRequestorId());
        args.addValue("subjectUserId", (Object)eventLog.getSubjectUserId());
        args.addValue("subjectOrgId", (Object)eventLog.getSubjectOrganizationId());
        args.addValue("notes", (Object)eventLog.getNotes());
        args.addValue("realmCode", (Object)eventLog.getRealm());
        int updateCount = new NamedParameterJdbcTemplate((JdbcOperations)this.getJdbcTemplate()).update(SQL_INSERT_SYSTEM_EVENT, (SqlParameterSource)args);
        if (updateCount != 1) {
            throw new IllegalStateException("Expected update count of 1 but got " + updateCount);
        }
        this.log.debug("Successfully created a new system event with id: {}", (Object)systemEventId);
        return String.valueOf(systemEventId);
    }
}

