/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.tif.iws.service;

import com.covisint.core.http.service.core.InvocationContext;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NotEmpty;
import com.covisint.core.support.primitive.StringSupport;
import com.covisint.platform.legacy.RealmLookupService;
import com.covisint.tif.iws.service.IDService;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IDServiceFactory {
    private static final Logger LOG = LoggerFactory.getLogger(IDServiceFactory.class);
    private final Map<String, IDService> realmIDServices = new HashMap<String, IDService>();
    private final Map<String, IDService> idServiceIdentifier;
    private final RealmLookupService realmService;
    private final IDService defaultIDService;

    public IDServiceFactory(@Nonnull RealmLookupService service, @Nonnull @NotEmpty Map<String, IDService> newIDServices, @Nonnull IDService defaultService) {
        if (newIDServices.isEmpty()) {
            throw new IllegalArgumentException("No id services provided.");
        }
        this.realmService = service;
        this.defaultIDService = defaultService;
        this.idServiceIdentifier = new HashMap<String, IDService>();
        for (Map.Entry<String, IDService> ct : newIDServices.entrySet()) {
            this.idServiceIdentifier.put(ct.getKey().toLowerCase(), ct.getValue());
        }
    }

    public IDService determineIDService() {
        String realmId = InvocationContext.getRealmId();
        if (StringSupport.trimOrNull((String)realmId) == null) {
            throw new IllegalStateException("No realm id present on the thread!  Check presence of x-realm header.");
        }
        if (this.realmIDServices.containsKey(realmId)) {
            return this.realmIDServices.get(realmId);
        }
        LOG.debug("Getting datasource name for realm {}", (Object)realmId);
        String datasourceName = "default";
        try {
            datasourceName = this.realmService.determineDatasourceName();
        }
        catch (IllegalArgumentException e) {
            LOG.debug("No datasource defined for realm {}. ", (Object)realmId);
        }
        IDService idService = this.idServiceIdentifier.get(datasourceName);
        if (idService == null) {
            LOG.debug("No id service found for datasourceName {}.  Returning default idservice.", (Object)datasourceName);
            idService = this.defaultIDService;
        }
        this.realmIDServices.put(realmId, idService);
        return idService;
    }
}

