/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.organization.client.organization;

import com.covisint.core.http.service.client.BaseResourceClient;
import com.covisint.core.http.service.client.ClientException;
import com.covisint.core.http.service.core.NamedResourceReference;
import com.covisint.core.http.service.core.ResourceReferenceNode;
import com.covisint.core.http.service.core.ServiceException;
import com.covisint.core.http.service.core.io.jsonp.JsonpSupport;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NotEmpty;
import com.covisint.platform.organization.client.organization.OrganizationClient;
import com.covisint.platform.organization.core.organization.Organization;
import com.damnhandy.uri.template.UriTemplate;
import com.damnhandy.uri.template.VariableExpansionException;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrganizationClientImpl
extends BaseResourceClient<Organization>
implements OrganizationClient {
    private final Logger log = LoggerFactory.getLogger(OrganizationClientImpl.class);
    private UriTemplate hierarchyUriTemplate;

    public void setHierarchyUriTemplate(@Nonnull UriTemplate template) {
        this.hierarchyUriTemplate = template;
    }

    @Override
    public final CheckedFuture<ResourceReferenceNode<NamedResourceReference>, ServiceException> getHierarchy(@Nonnull @NotEmpty String organizationId, @Nonnull HttpContext context) {
        ResourceReferenceNode cachedResult = null;
        final String cacheKey = String.format("get-hierarchy-by-id-%s", organizationId);
        cachedResult = (ResourceReferenceNode)this.getLocalCache().getIfPresent((Object)cacheKey);
        if (cachedResult != null) {
            this.log.debug("Found active cache for key {}; using it.", (Object)cacheKey);
            return Futures.immediateCheckedFuture((Object)cachedResult);
        }
        try {
            String url = this.hierarchyUriTemplate.set("organizationId", (Object)organizationId).expand();
            CheckedFuture futureResult = this.execute((HttpUriRequest)new HttpGet(url), JsonpSupport.RESOURCE_HIERARCHY_V1_MEDIA_TYPE, context);
            Futures.addCallback((ListenableFuture)futureResult, (FutureCallback)new FutureCallback<ResourceReferenceNode<NamedResourceReference>>(){

                public void onSuccess(ResourceReferenceNode<NamedResourceReference> result) {
                    if (result == null) {
                        return;
                    }
                    OrganizationClientImpl.this.getLocalCache().put((Object)cacheKey, result);
                    OrganizationClientImpl.this.log.debug("Successfully retrieved and cached resource for key {}", (Object)cacheKey);
                }

                public void onFailure(Throwable t) {
                }
            });
            return futureResult;
        }
        catch (VariableExpansionException e) {
            this.log.error("Error occurred while expanding URL template.", (Throwable)e);
            throw new ClientException("Error occurred while expanding URL template.");
        }
    }

    public CheckedFuture<Organization, ServiceException> delete(String id, HttpContext httpContext) {
        throw new UnsupportedOperationException();
    }
}

