/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.oauth.client.sdk;

import com.covisint.core.http.service.core.Page;
import com.covisint.core.http.service.core.ServiceException;
import com.covisint.core.http.service.core.SortCriteria;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NotEmpty;
import com.covisint.core.support.httpclient.HttpClientBuilder;
import com.covisint.platform.oauth.client.granttype.clientsecret.ClientSecretClientFactory;
import com.covisint.platform.oauth.client.granttype.clientsecret.ClientSecretGrantTypeClientImpl;
import com.covisint.platform.oauth.client.token.sdk.AuthConfigurationProvider;
import com.covisint.platform.oauth.client.token.sdk.DefaultAuthConfigurationProvider;
import com.covisint.platform.oauth.client.token.sdk.TokenSupplier;
import com.covisint.platform.oauth.core.domain.ClientSecretGrantType;
import com.google.common.base.Supplier;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.CheckedFuture;
import java.util.List;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;

public class ClientSecretGrantTypeSDK
extends ClientSecretClientFactory {
    private AuthConfigurationProvider authConfigProvider;

    public ClientSecretGrantTypeSDK(@Nonnull @NotEmpty String serviceUrl) {
        super(serviceUrl);
    }

    @Nonnull
    protected AuthConfigurationProvider getAuthConfigProvider() {
        if (this.authConfigProvider == null) {
            this.authConfigProvider = new DefaultAuthConfigurationProvider();
        }
        return this.authConfigProvider;
    }

    protected HttpClientBuilder populateHttpClientBuilder(HttpClientBuilder builder) {
        TokenSupplier tokenSupplier = new TokenSupplier(this.getAuthConfigProvider());
        builder.addAuthorizationTokenInterceptor((Supplier)tokenSupplier);
        return builder;
    }

    public ClientSecretGrantTypeSDK setAuthConfigProvider(@Nonnull AuthConfigurationProvider provider) {
        this.authConfigProvider = provider;
        return this;
    }

    public ClientSecretGrantTypeClientImpl create() {
        throw new UnsupportedOperationException("Please use #newClient to create new client instances.");
    }

    @Nonnull
    public ClientSecretGrantTypeClient newClient() {
        return new ClientImpl((ClientSecretGrantTypeClientImpl)super.create());
    }

    private static final class ClientImpl
    implements ClientSecretGrantTypeClient {
        private final ClientSecretGrantTypeClientImpl delegate;

        private ClientImpl(@Nonnull ClientSecretGrantTypeClientImpl newDelegate) {
            this.delegate = newDelegate;
        }

        @Override
        @Nonnull
        public CheckedFuture<ClientSecretGrantType, ServiceException> get(@Nonnull @NotEmpty String subjectId, @Nonnull @NotEmpty String grantId) {
            return this.delegate.get(subjectId, grantId, (HttpContext)new BasicHttpContext());
        }

        @Override
        @Nonnull
        public CheckedFuture<List<ClientSecretGrantType>, ServiceException> listClientSecretGrants(@Nonnull @NotEmpty String subjectId, @Nonnull Page page) {
            return this.delegate.search(subjectId, (Multimap<String, String>)ArrayListMultimap.create(), SortCriteria.NONE, page, (HttpContext)new BasicHttpContext());
        }

        @Override
        @Nonnull
        public CheckedFuture<ClientSecretGrantType, ServiceException> add(@Nonnull @NotEmpty String subjectId, @Nonnull ClientSecretGrantType grant) {
            return this.delegate.add(subjectId, grant, (HttpContext)new BasicHttpContext());
        }

        @Override
        @Nonnull
        public CheckedFuture<ClientSecretGrantType, ServiceException> delete(@Nonnull @NotEmpty String subjectId, @Nonnull @NotEmpty String grantId) {
            return this.delegate.delete(subjectId, grantId, (HttpContext)new BasicHttpContext());
        }
    }

    public static interface ClientSecretGrantTypeClient {
        @Nonnull
        public CheckedFuture<ClientSecretGrantType, ServiceException> get(@Nonnull @NotEmpty String var1, @Nonnull @NotEmpty String var2);

        @Nonnull
        public CheckedFuture<List<ClientSecretGrantType>, ServiceException> listClientSecretGrants(@Nonnull @NotEmpty String var1, @Nonnull Page var2);

        @Nonnull
        public CheckedFuture<ClientSecretGrantType, ServiceException> add(@Nonnull @NotEmpty String var1, @Nonnull ClientSecretGrantType var2);

        @Nonnull
        public CheckedFuture<ClientSecretGrantType, ServiceException> delete(@Nonnull @NotEmpty String var1, @Nonnull @NotEmpty String var2);
    }
}

