/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.core.http.service.core;

import com.covisint.core.http.service.core.NamedResourceReference;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NonnullElements;
import com.covisint.core.support.constraint.Nullable;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Set;

public final class ResourceReferenceNode<T extends NamedResourceReference> {
    private final T value;
    private final T parent;
    private Set<ResourceReferenceNode> children;

    public ResourceReferenceNode(@Nonnull T newValue, @Nullable T newParent) {
        this.value = newValue;
        this.parent = newParent;
    }

    @Nonnull
    public T getValue() {
        return this.value;
    }

    @Nullable
    public T getParent() {
        return this.parent;
    }

    public boolean addChild(@Nonnull ResourceReferenceNode newChild) {
        if (this.children == null) {
            this.children = new HashSet<ResourceReferenceNode>();
        }
        return this.children.add(newChild);
    }

    @Nullable
    @NonnullElements
    public Iterable<ResourceReferenceNode> getChildren() {
        if (this.children != null) {
            return ImmutableSet.copyOf(this.children);
        }
        return null;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.value, this.parent});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ResourceReferenceNode)) {
            return false;
        }
        ResourceReferenceNode other = (ResourceReferenceNode)obj;
        return Objects.equal(this.value, other.value) && Objects.equal(this.parent, other.parent);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("value", this.value).add("parent", this.parent).add("children", this.children).toString();
    }
}

