/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.core.http.service.core.io.jsonp;

import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.Nullable;
import com.covisint.core.support.primitive.StringSupport;
import com.google.common.net.MediaType;
import javax.json.JsonObjectBuilder;
import javax.json.JsonString;
import javax.json.JsonValue;

public final class JsonpSupport {
    public static final MediaType HTTP_SERVICE_ERROR_V1_MEDIA_TYPE = MediaType.parse((String)"application/vnd.com.covisint.error.v1+json").withoutParameters();
    public static final MediaType RESOURCE_HIERARCHY_V1_MEDIA_TYPE = MediaType.parse((String)"application/vnd.com.covisint.platform.reference.hierarchy.v1+json").withoutParameters();
    public static final String ID_PROP = "id";
    public static final String VERSION_PROP = "version";
    public static final String CREATOR_PROP = "creator";
    public static final String CREATOR_APP_PROP = "creatorAppId";
    public static final String CREATION_PROP = "creation";
    public static final String REALM_PROP = "realm";
    public static final String TYPE_PROP = "type";
    public static final String NAME_PROP = "name";
    public static final String LANGUAGE_PROP = "lang";
    public static final String TEXT_PROP = "text";
    public static final String DESCRIPTION_PROP = "description";
    public static final String CHILDREN_PROP = "children";
    public static final String HTTP_STATUS_PROP = "status";
    public static final String API_STATUS_CODE_PROP = "apiStatusCode";
    public static final String API_MESSAGE_PROP = "apiMessage";

    private JsonpSupport() {
    }

    public static boolean isArray(@Nonnull JsonValue value) {
        return JsonValue.ValueType.ARRAY.equals((Object)value.getValueType());
    }

    public static boolean isNull(@Nonnull JsonValue value) {
        return JsonValue.ValueType.NULL.equals((Object)value.getValueType());
    }

    public static boolean isNumber(@Nonnull JsonValue value) {
        return JsonValue.ValueType.NUMBER.equals((Object)value.getValueType());
    }

    public static boolean isObject(@Nonnull JsonValue value) {
        return JsonValue.ValueType.OBJECT.equals((Object)value.getValueType());
    }

    public static boolean isString(@Nonnull JsonValue value) {
        return JsonValue.ValueType.STRING.equals((Object)value.getValueType());
    }

    public static void addPropertyIfNonnullValue(@Nonnull JsonObjectBuilder jsonBuilder, @Nonnull String propertyName, @Nullable String propertyValue) {
        String trimmedValue = StringSupport.trim((String)propertyValue);
        if (trimmedValue != null) {
            jsonBuilder.add(propertyName, trimmedValue);
        }
    }

    public static boolean isJsonStringPropertyEmptyOrNull(@Nullable JsonString property) {
        return property == null || StringSupport.trimOrNull((String)property.getString()) == null;
    }
}

