/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.service.core.service;

import com.covisint.core.http.service.core.AbstractRealmScopedResource;
import com.covisint.core.http.service.core.ResourceReference;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NotEmpty;
import com.covisint.core.support.constraint.Nullable;
import com.covisint.core.support.constraint.NullableElements;
import com.covisint.core.support.constraint.Searchable;
import com.covisint.core.support.primitive.StringSupport;
import com.google.common.base.Objects;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class Service
extends AbstractRealmScopedResource<Service> {
    private static final long serialVersionUID = -7715983614974238263L;
    private static final String DEFAULT_URL_ATTR = "default";
    @Searchable(name="name")
    private Map<String, String> names = new HashMap<String, String>();
    @Searchable(name="description")
    private Map<String, String> descriptions = new HashMap<String, String>();
    @Searchable
    private ResourceReference parentService;
    @Searchable(name="category")
    private Map<String, String> categories = new HashMap<String, String>();
    @Searchable
    private ResourceReference owningOrganization;
    private Map<String, String> urls = new HashMap<String, String>();
    @Searchable(name="remoteAppId")
    private String remoteApplicationId;
    @Searchable
    private String mobileServiceId;
    private String federationConnectionWizard;
    private boolean protectionEnabled;
    private boolean messagingEnabled;
    private String defaultName;
    private String defaultDescription;

    @Nonnull
    @NullableElements
    public Map<String, String> getNames() {
        return Collections.unmodifiableMap(this.names);
    }

    @Nonnull
    @NullableElements
    public Map<String, String> getDescriptions() {
        return Collections.unmodifiableMap(this.descriptions);
    }

    @Nullable
    public String getDefaultName() {
        if (this.defaultName != null) {
            return this.defaultName;
        }
        String en = Locale.ENGLISH.getLanguage();
        if (this.names.containsKey(en)) {
            return this.names.get(en);
        }
        return null;
    }

    @Nonnull
    public Service setDefaultName(@Nonnull @NotEmpty String name) {
        this.defaultName = name;
        this.names.put(Locale.ENGLISH.getLanguage(), name);
        return this;
    }

    @Nullable
    public String getDefaultDescription() {
        if (this.defaultDescription != null) {
            return this.defaultDescription;
        }
        String en = Locale.ENGLISH.getLanguage();
        if (this.descriptions.containsKey(en)) {
            return this.descriptions.get(en);
        }
        return null;
    }

    @Nonnull
    public Service setDefaultDescription(@Nonnull @NotEmpty String description) {
        this.defaultDescription = description;
        this.descriptions.put(Locale.ENGLISH.getLanguage(), description);
        return this;
    }

    @Nonnull
    public Service setNames(Map<String, String> newNames) {
        this.names = new HashMap<String, String>();
        if (newNames != null) {
            for (Map.Entry<String, String> name : newNames.entrySet()) {
                String trimmedName = StringSupport.trimOrNull((String)name.getValue());
                if (trimmedName == null) continue;
                this.names.put(name.getKey(), trimmedName);
            }
        }
        return this;
    }

    @Nonnull
    public Service addName(@Nonnull @NotEmpty String lang, @Nonnull @NotEmpty String text) {
        this.names.put(lang, StringSupport.trim((String)text));
        return this;
    }

    @Nonnull
    public Service setDescriptions(Map<String, String> newDescriptions) {
        this.descriptions = new HashMap<String, String>();
        if (newDescriptions != null) {
            for (Map.Entry<String, String> description : newDescriptions.entrySet()) {
                String trimmedDescription = StringSupport.trimOrNull((String)description.getValue());
                if (trimmedDescription == null) continue;
                this.descriptions.put(description.getKey(), trimmedDescription);
            }
        }
        return this;
    }

    @Nonnull
    public Service addDescription(@Nonnull @NotEmpty String lang, @Nonnull @NotEmpty String text) {
        this.descriptions.put(lang, StringSupport.trim((String)text));
        return this;
    }

    @Nullable
    public ResourceReference getParentService() {
        return this.parentService;
    }

    @Nonnull
    public Service setParentService(@Nonnull ResourceReference ref) {
        this.parentService = ref;
        return this;
    }

    @Nonnull
    public Service setParentServiceId(@Nonnull @NotEmpty String parentServiceId) {
        this.parentService = new ResourceReference(parentServiceId, "service");
        return this;
    }

    @Nonnull
    @NullableElements
    public Map<String, String> getCategories() {
        return Collections.unmodifiableMap(this.categories);
    }

    @Nonnull
    public Service setCategory(@Nonnull @NotEmpty Map<String, String> newCategories) {
        this.categories = new HashMap<String, String>();
        if (newCategories != null) {
            for (Map.Entry<String, String> category : newCategories.entrySet()) {
                String trimmedUrl = StringSupport.trimOrNull((String)category.getValue());
                if (trimmedUrl == null) continue;
                this.categories.put(category.getKey(), trimmedUrl);
            }
        }
        return this;
    }

    @Nonnull
    public Service addCategory(@Nonnull @NotEmpty String lang, @Nonnull @NotEmpty String text) {
        this.categories.put(lang, StringSupport.trim((String)text));
        return this;
    }

    @Nonnull
    @NullableElements
    public Map<String, String> getUrls() {
        return Collections.unmodifiableMap(this.urls);
    }

    @Nullable
    public String getDefaultUrl() {
        return this.urls.get(DEFAULT_URL_ATTR);
    }

    @Nonnull
    public Service setUrls(Map<String, String> newUrls) {
        this.urls = new HashMap<String, String>();
        if (newUrls != null) {
            for (Map.Entry<String, String> url : newUrls.entrySet()) {
                String trimmedUrl = StringSupport.trimOrNull((String)url.getValue());
                if (trimmedUrl == null) continue;
                this.urls.put(url.getKey(), trimmedUrl);
            }
        }
        return this;
    }

    @Nonnull
    public Service addUrl(@Nonnull @NotEmpty String type, @Nonnull @NotEmpty String url) {
        this.urls.put(type, StringSupport.trim((String)url));
        return this;
    }

    @Nonnull
    public Service setDefaultUrl(@Nonnull @NotEmpty String url) {
        this.addUrl(DEFAULT_URL_ATTR, url);
        return this;
    }

    @Nullable
    public String getRemoteApplicationId() {
        return this.remoteApplicationId;
    }

    @Nonnull
    public Service setRemoteApplicationId(@Nonnull @NotEmpty String id) {
        this.remoteApplicationId = StringSupport.trim((String)id);
        return this;
    }

    @Nullable
    public ResourceReference getOwningOrganization() {
        return this.owningOrganization;
    }

    @Nonnull
    public Service setOwningOrganization(@Nonnull @NotEmpty ResourceReference ref) {
        this.owningOrganization = ref;
        return this;
    }

    @Nonnull
    public Service setOwningOrganizationId(@Nonnull @NotEmpty String organizationId) {
        this.owningOrganization = new ResourceReference(organizationId, "organization");
        return this;
    }

    @Nullable
    public String getMobileServiceId() {
        return this.mobileServiceId;
    }

    @Nonnull
    public Service setMobileServiceId(@Nonnull @NotEmpty String id) {
        this.mobileServiceId = StringSupport.trim((String)id);
        return this;
    }

    @Nullable
    public String getFederationConnectionWizard() {
        return this.federationConnectionWizard;
    }

    @Nonnull
    public Service setFederationConnectionWizard(@Nonnull @NotEmpty String wizard) {
        this.federationConnectionWizard = StringSupport.trim((String)wizard);
        return this;
    }

    public boolean isMessagingEnabled() {
        return this.messagingEnabled;
    }

    @Nonnull
    public Service setMessagingEnabled(boolean enabled) {
        this.messagingEnabled = enabled;
        return this;
    }

    public boolean isProtectionEnabled() {
        return this.protectionEnabled;
    }

    @Nonnull
    public Service setProtectionEnabled(boolean enabled) {
        this.protectionEnabled = enabled;
        return this;
    }

    public boolean equals(Object obj) {
        return this.isResourceIdentityEqual(Service.class, obj);
    }

    public int hashCode() {
        return this.getResourceIdentityHashCode();
    }

    public String toString() {
        return this.populateToStringHelper(Objects.toStringHelper(Service.class)).add("defaultName", (Object)this.getDefaultName()).add("defaultDescription", (Object)this.getDefaultDescription()).add("name", this.names).add("description", this.descriptions).add("parentService", (Object)this.parentService).add("category", this.categories).add("urls", this.urls).add("remoteApplicationId", (Object)this.remoteApplicationId).add("owningOrganization", (Object)this.owningOrganization).add("mobileServiceId", (Object)this.mobileServiceId).add("federationConnectionWizard", (Object)this.federationConnectionWizard).add("protectionEnabled", this.protectionEnabled).add("messagingEnabled", this.messagingEnabled).toString();
    }
}

