/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.service.core.service.grant;

import com.covisint.core.http.service.core.AbstractRealmScopedResource;
import com.covisint.core.http.service.core.ResourceReference;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NotEmpty;
import com.covisint.core.support.constraint.Nullable;
import com.covisint.platform.service.core.service.grant.GrantStatus;
import com.google.common.base.Objects;

public class ServicePackageGrant
extends AbstractRealmScopedResource<ServicePackageGrant> {
    private static final long serialVersionUID = -3191913723255767133L;
    private GrantStatus status = GrantStatus.ACTIVE;
    private ResourceReference grantee;
    private ResourceReference servicePackage;
    private boolean organizationAdministered;

    @Nullable
    public GrantStatus getStatus() {
        return this.status;
    }

    @Nonnull
    public ServicePackageGrant setStatus(@Nonnull GrantStatus newStatus) {
        this.status = newStatus;
        return this;
    }

    @Nullable
    public ResourceReference getGrantee() {
        return this.grantee;
    }

    @Nonnull
    public ServicePackageGrant setGrantee(@Nonnull ResourceReference newGrantee) {
        this.grantee = newGrantee;
        return this;
    }

    @Nonnull
    public ServicePackageGrant setPersonGrantee(@Nonnull @NotEmpty String personId) {
        this.grantee = new ResourceReference(personId, "person");
        return this;
    }

    @Nonnull
    public ServicePackageGrant setOrganizationGrantee(@Nonnull @NotEmpty String organizationId) {
        this.grantee = new ResourceReference(organizationId, "organization");
        return this;
    }

    @Nullable
    public ResourceReference getServicePackage() {
        return this.servicePackage;
    }

    @Nonnull
    public ServicePackageGrant setServicePackage(@Nonnull ResourceReference newServicePackage) {
        this.servicePackage = newServicePackage;
        return this;
    }

    @Nonnull
    public ServicePackageGrant setServicePackageId(@Nonnull @NotEmpty String id) {
        this.servicePackage = new ResourceReference(id, "servicePackage");
        return this;
    }

    public boolean isOrganizationAdministered() {
        return this.organizationAdministered;
    }

    @Nonnull
    public ServicePackageGrant setOrganizationAdministered(boolean administered) {
        this.organizationAdministered = administered;
        return this;
    }

    public boolean equals(Object obj) {
        return this.isResourceIdentityEqual(ServicePackageGrant.class, obj);
    }

    public int hashCode() {
        return this.getResourceIdentityHashCode();
    }

    public String toString() {
        return this.populateToStringHelper(Objects.toStringHelper(ServicePackageGrant.class)).add("status", (Object)this.status).add("grantee", (Object)this.grantee).add("servicePackage", (Object)this.servicePackage).add("organizationAdministered", this.organizationAdministered).toString();
    }
}

