/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.service.core.service.io.jsonp;

import com.covisint.core.http.service.core.ResourceReference;
import com.covisint.core.http.service.core.io.jsonp.AbstractRealmScopedResourceReader;
import com.covisint.core.http.service.core.io.jsonp.JsonpSupport;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.Nullable;
import com.covisint.platform.service.core.service.CodeRestriction;
import com.covisint.platform.service.core.service.CodeType;
import com.covisint.platform.service.core.service.ServiceJsonpSupport;
import com.covisint.platform.service.core.service.ServicePackage;
import com.covisint.platform.service.core.service.SupportedMediaType;
import com.google.common.base.Enums;
import com.google.common.net.MediaType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;

public class ServicePackageReader
extends AbstractRealmScopedResourceReader<ServicePackage> {
    private void readTermsAndConditions(@Nonnull JsonObject json, @Nonnull ServicePackage pkg) {
        HashMap<String, String> termsAndConditions = new HashMap<String, String>();
        JsonArray jsonArray = json.getJsonArray("termsAndConditions");
        if (jsonArray != null) {
            for (JsonValue value : jsonArray) {
                if (!JsonpSupport.isObject((JsonValue)value)) continue;
                JsonObject jsonObject = (JsonObject)value;
                String type = null;
                String tacId = null;
                if (!JsonpSupport.isJsonStringPropertyEmptyOrNull((JsonString)jsonObject.getJsonString("type"))) {
                    type = jsonObject.getJsonString("type").getString().toLowerCase();
                }
                if (!JsonpSupport.isJsonStringPropertyEmptyOrNull((JsonString)jsonObject.getJsonString("tacId"))) {
                    tacId = jsonObject.getJsonString("tacId").getString();
                }
                termsAndConditions.put(type, tacId);
            }
        }
        pkg.setTermsAndConditions(termsAndConditions);
    }

    private void readCodeRestrictions(@Nonnull JsonObject json, @Nonnull ServicePackage pkg) {
        ArrayList<CodeRestriction> codeRestrictions = new ArrayList<CodeRestriction>();
        JsonArray jsonArray = json.getJsonArray("codeRestrictions");
        if (jsonArray != null) {
            for (JsonValue value : jsonArray) {
                if (!JsonpSupport.isObject((JsonValue)value)) continue;
                JsonObject jsonObject = (JsonObject)value;
                String requestorType = null;
                if (!JsonpSupport.isJsonStringPropertyEmptyOrNull((JsonString)jsonObject.getJsonString("requestorType"))) {
                    requestorType = jsonObject.getJsonString("requestorType").getString();
                }
                CodeType restriction = this.getRestriction(jsonObject.getJsonString("restriction"));
                codeRestrictions.add(new CodeRestriction(requestorType, restriction));
            }
        }
        pkg.setCodeRestriction(codeRestrictions);
    }

    private CodeType getRestriction(@Nullable JsonString json) {
        if (JsonpSupport.isJsonStringPropertyEmptyOrNull((JsonString)json)) {
            return CodeType.MISSING;
        }
        if (!Enums.getIfPresent(CodeType.class, (String)json.getString().toUpperCase()).isPresent()) {
            return CodeType.INVALID;
        }
        return (CodeType)((Object)Enums.getIfPresent(CodeType.class, (String)json.getString().toUpperCase()).get());
    }

    private void readCategories(@Nonnull JsonObject json, @Nonnull ServicePackage pkg) {
        Map<String, String> categories = ServiceJsonpSupport.readMap(json, "category", "lang", "text");
        pkg.setCategories(categories);
    }

    private void readApprovalRequirements(@Nonnull JsonObject json, @Nonnull ServicePackage pkg) {
        JsonArray requiredApprovals = json.getJsonArray("requiredApprovals");
        if (requiredApprovals == null) {
            return;
        }
        block10: for (int i = 0; i < requiredApprovals.size(); ++i) {
            JsonString approvalType = requiredApprovals.getJsonString(i);
            switch (approvalType.getString()) {
                case "organizationAdmin": {
                    pkg.setOrganizationAdminApprovalRequired(true);
                    continue block10;
                }
                case "applicationAdmin": {
                    pkg.setApplicationAdminApprovalRequired(true);
                    continue block10;
                }
                case "provisioningAdmin": {
                    pkg.setProvisioningAdminApprovalRequired(true);
                    continue block10;
                }
            }
        }
    }

    private void readFlags(JsonObject json, ServicePackage pkg) {
        if (json.containsKey((Object)"protected")) {
            pkg.setProtectionEnabled(json.getBoolean("protected"));
        }
        if (json.containsKey((Object)"requestable")) {
            pkg.setRequestsEnabled(json.getBoolean("requestable"));
        }
        if (json.containsKey((Object)"grantable")) {
            pkg.setGrantsEnabled(json.getBoolean("grantable"));
        }
        if (json.containsKey((Object)"displayable")) {
            pkg.setDisplayEnabled(json.getBoolean("displayable"));
        }
        if (json.containsKey((Object)"requestReasonRequired")) {
            pkg.setUserRequestReasonRequired(json.getBoolean("requestReasonRequired"));
        }
    }

    @Nonnull
    protected ServicePackage createResource(@Nonnull MediaType mediaType) {
        return new ServicePackage();
    }

    @Nonnull
    protected ServicePackage readResource(@Nonnull MediaType mediaType, @Nonnull JsonObject json) {
        ResourceReference ownerOrgRef;
        ServicePackage pkg = (ServicePackage)super.readResource(mediaType, json);
        pkg.setNames(ServiceJsonpSupport.readMap(json, "name", "lang", "text"));
        pkg.setDescriptions(ServiceJsonpSupport.readMap(json, "description", "lang", "text"));
        this.readTermsAndConditions(json, pkg);
        this.readCodeRestrictions(json, pkg);
        this.readCategories(json, pkg);
        this.readApprovalRequirements(json, pkg);
        ResourceReference parentRef = ServicePackageReader.readResourceReference((JsonObject)json.getJsonObject("parent"));
        if (parentRef != null) {
            pkg.setParentPackage(parentRef);
        }
        if ((ownerOrgRef = ServicePackageReader.readResourceReference((JsonObject)json.getJsonObject("owningOrganization"))) != null) {
            pkg.setOwningOrganization(ownerOrgRef);
        }
        this.readFlags(json, pkg);
        return pkg;
    }

    @Nonnull
    public Class<ServicePackage> getResourceType() {
        return ServicePackage.class;
    }

    public boolean isReadable(@Nonnull MediaType mediaType) {
        return ServiceJsonpSupport.isMediaTypeSame(SupportedMediaType.SERVICE_PACKAGE_MT, mediaType);
    }
}

