/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.service.core.service.io.jsonp;

import com.covisint.core.http.service.core.ResourceReference;
import com.covisint.core.http.service.core.io.jsonp.AbstractRealmScopedResourceReader;
import com.covisint.core.http.service.core.io.jsonp.JsonpSupport;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.platform.service.core.service.Service;
import com.covisint.platform.service.core.service.ServiceJsonpSupport;
import com.covisint.platform.service.core.service.SupportedMediaType;
import com.google.common.net.MediaType;
import java.util.Map;
import javax.json.JsonObject;
import javax.json.JsonString;

public class ServiceReader
extends AbstractRealmScopedResourceReader<Service> {
    private void readUrls(@Nonnull JsonObject json, @Nonnull Service service) {
        Map<String, String> urls = ServiceJsonpSupport.readMap(json, "urls", "type", "value");
        service.setUrls(urls);
    }

    private void readFlags(JsonObject json, Service service) {
        if (json.containsKey((Object)"protected")) {
            service.setProtectionEnabled(json.getBoolean("protected"));
        }
        if (json.containsKey((Object)"messagingEnabled")) {
            service.setMessagingEnabled(json.getBoolean("messagingEnabled"));
        }
    }

    @Nonnull
    protected Service createResource(@Nonnull MediaType mediaType) {
        return new Service();
    }

    @Nonnull
    protected Service readResource(@Nonnull MediaType mediaType, @Nonnull JsonObject json) {
        JsonString jsonString;
        ResourceReference ownerOrgRef;
        Service service = (Service)super.readResource(mediaType, json);
        service.setCategory(ServiceJsonpSupport.readMap(json, "category", "lang", "text"));
        service.setNames(ServiceJsonpSupport.readMap(json, "name", "lang", "text"));
        service.setDescriptions(ServiceJsonpSupport.readMap(json, "description", "lang", "text"));
        this.readUrls(json, service);
        ResourceReference parentRef = ServiceReader.readResourceReference((JsonObject)json.getJsonObject("parentService"));
        if (parentRef != null) {
            service.setParentService(parentRef);
        }
        if ((ownerOrgRef = ServiceReader.readResourceReference((JsonObject)json.getJsonObject("owningOrganization"))) != null) {
            service.setOwningOrganization(ownerOrgRef);
        }
        if (!JsonpSupport.isJsonStringPropertyEmptyOrNull((JsonString)(jsonString = json.getJsonString("remoteAppId")))) {
            service.setRemoteApplicationId(jsonString.getString());
        }
        if (!JsonpSupport.isJsonStringPropertyEmptyOrNull((JsonString)(jsonString = json.getJsonString("mobileServiceId")))) {
            service.setMobileServiceId(jsonString.getString());
        }
        if (!JsonpSupport.isJsonStringPropertyEmptyOrNull((JsonString)(jsonString = json.getJsonString("federationConnectionWizard")))) {
            service.setFederationConnectionWizard(jsonString.getString());
        }
        this.readFlags(json, service);
        return service;
    }

    @Nonnull
    public Class<Service> getResourceType() {
        return Service.class;
    }

    public boolean isReadable(@Nonnull MediaType mediaType) {
        return ServiceJsonpSupport.isMediaTypeSame(SupportedMediaType.SERVICE_MT, mediaType);
    }
}

