/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.service.core.service.request;

import com.covisint.core.http.service.core.AbstractRealmScopedResource;
import com.covisint.core.http.service.core.ResourceReference;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NotEmpty;
import com.covisint.core.support.constraint.Nullable;
import com.covisint.core.support.constraint.Searchable;
import com.covisint.platform.service.core.service.RequestorType;
import com.google.common.base.Objects;
import java.io.Serializable;

public class ServicePackageRequest
extends AbstractRealmScopedResource<ServicePackageRequest> {
    private static final long serialVersionUID = 1746240833813512882L;
    @Searchable
    private ResourceReference requestor;
    private ResourceReference requestedPackage;
    private String reason;
    private ResourceReference parentRequest;

    @Nullable
    public ResourceReference getRequestor() {
        return this.requestor;
    }

    @Nonnull
    public ServicePackageRequest setRequestor(@Nonnull ResourceReference newRequestor) {
        this.requestor = newRequestor;
        return this;
    }

    @Nonnull
    public ServicePackageRequest setRequestor(@Nonnull @NotEmpty String personId, @Nonnull RequestorType requestorType) {
        this.requestor = new ResourceReference(personId, requestorType.toString());
        return this;
    }

    @Nullable
    public ResourceReference getRequestedPackage() {
        return this.requestedPackage;
    }

    @Nonnull
    public ServicePackageRequest setRequestedPackage(@Nonnull ResourceReference newPackage) {
        this.requestedPackage = newPackage;
        return this;
    }

    @Nonnull
    public ServicePackageRequest setRequestedPackageId(@Nonnull @NotEmpty String id) {
        this.requestedPackage = new ResourceReference(id, "servicePackage");
        return this;
    }

    @Nullable
    public String getReason() {
        return this.reason;
    }

    @Nonnull
    public ServicePackageRequest setReason(@Nonnull @NotEmpty String newReason) {
        this.reason = newReason;
        return this;
    }

    @Nullable
    public ResourceReference getParentRequest() {
        return this.parentRequest;
    }

    @Nonnull
    public ServicePackageRequest setParentRequest(@Nonnull ResourceReference request) {
        this.parentRequest = request;
        return this;
    }

    @Nonnull
    public ServicePackageRequest setParentRequest(@Nonnull @NotEmpty String parentRequestId, RequestType requestType) {
        this.parentRequest = new ResourceReference(parentRequestId, requestType.toString());
        return this;
    }

    public boolean equals(Object obj) {
        return this.isResourceIdentityEqual(ServicePackageRequest.class, obj);
    }

    public int hashCode() {
        return this.getResourceIdentityHashCode();
    }

    public String toString() {
        return this.populateToStringHelper(Objects.toStringHelper((Object)((Object)this))).add("requestor", (Object)this.requestor).add("requestedPackage", (Object)this.requestedPackage).add("reason", (Object)this.reason).add("parentRequest", (Object)this.parentRequest).toString();
    }

    public static enum RequestStep {
        STEP_ONE(1),
        STEP_TWO(2),
        STEP_THREE(3);

        private int step;

        private RequestStep(int newStep) {
            this.step = newStep;
        }

        public int getStep() {
            return this.step;
        }
    }

    public static enum Phase {
        ORGANIZATION_ADMIN_APPROVAL_PHASE(1),
        APPLICATION_ADMIN_APPROVAL_PHASE(2),
        PROVISIONING_ADMIN_APPROVAL_PHASE(3),
        USER_APPLICATION_REQUEST_PHASE(4);

        private int phaseId;

        private Phase(int newPhaseId) {
            this.phaseId = newPhaseId;
        }

        public int getPhaseId() {
            return this.phaseId;
        }
    }

    public class RequestWorkflowHistory
    implements Serializable {
        private static final long serialVersionUID = 8318389484637281778L;
        private String requestId;
        private int currentPhaseEnum;
        private long commentDate;
        private String evaluator;
        private String commentText;
        private String currentStepAdditionalInfo;
        private boolean approved;
        private long requestStep;
        private String accessLevel;

        @Nonnull
        @NotEmpty
        public String getRequestId() {
            return this.requestId;
        }

        @Nonnull
        public RequestWorkflowHistory setRequestId(@Nonnull @NotEmpty String id) {
            this.requestId = id;
            return this;
        }

        public int getCurrentPhaseEnum() {
            return this.currentPhaseEnum;
        }

        @Nonnull
        public RequestWorkflowHistory setCurrentPhaseEnum(@Nonnull int phaseId) {
            this.currentPhaseEnum = phaseId;
            return this;
        }

        public long getCommentDate() {
            return this.commentDate;
        }

        @Nonnull
        public RequestWorkflowHistory setCommentDate(long date) {
            this.commentDate = date;
            return this;
        }

        @Nullable
        public String getEvaluator() {
            return this.evaluator;
        }

        @Nonnull
        public RequestWorkflowHistory setEvaluator(@Nonnull @NotEmpty String newEvaluator) {
            this.evaluator = newEvaluator;
            return this;
        }

        @Nullable
        public String getCommentText() {
            return this.commentText;
        }

        @Nonnull
        public RequestWorkflowHistory setCommentText(String comment) {
            this.commentText = comment;
            return this;
        }

        @Nullable
        public String getCurrentStepAdditionalInfo() {
            return this.currentStepAdditionalInfo;
        }

        @Nonnull
        public RequestWorkflowHistory setCurrentStepAdditionalInfo(String additionalInfo) {
            this.currentStepAdditionalInfo = additionalInfo;
            return this;
        }

        public boolean isApproved() {
            return this.approved;
        }

        @Nonnull
        public RequestWorkflowHistory setApproved(boolean approvedFlag) {
            this.approved = approvedFlag;
            return this;
        }

        public long getRequestStep() {
            return this.requestStep;
        }

        @Nonnull
        public RequestWorkflowHistory setRequestStep(long step) {
            this.requestStep = step;
            return this;
        }

        @Nullable
        public String getAccessLevel() {
            return this.accessLevel;
        }

        @Nonnull
        public RequestWorkflowHistory setAccessLevel(String newAccessLevel) {
            this.accessLevel = newAccessLevel;
            return this;
        }

        public String toString() {
            return ServicePackageRequest.this.populateToStringHelper(Objects.toStringHelper((Object)this)).add("requestId", (Object)this.requestId).add("currentPhaseEnum", this.currentPhaseEnum).add("commentDate", this.commentDate).add("evaluator", (Object)this.evaluator).add("commentText", (Object)this.commentText).add("currentStepAdditionalInfo", (Object)this.currentStepAdditionalInfo).add("approved", this.approved).add("requestStep", this.requestStep).add("accessLevel", (Object)this.accessLevel).toString();
        }

        public final int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.getRequestId(), this.getRequestStep()});
        }

        public final boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof RequestWorkflowHistory)) {
                return false;
            }
            RequestWorkflowHistory other = (RequestWorkflowHistory)obj;
            return this.getRequestId().equals(other.getRequestId()) && this.getRequestStep() == other.getRequestStep();
        }
    }

    public static enum RequestType {
        PERSON_REQUEST("personRequest"),
        PACKAGE_REQUEST("servicePackageRequest");

        private final String id;

        private RequestType(String newId) {
            this.id = newId;
        }

        public String toString() {
            return this.id;
        }
    }
}

