/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.service.client.sdk;

import com.covisint.core.http.service.core.Page;
import com.covisint.core.http.service.core.Resource;
import com.covisint.core.http.service.core.ServiceException;
import com.covisint.core.http.service.core.SortCriteria;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NotEmpty;
import com.covisint.core.support.httpclient.HttpClientBuilder;
import com.covisint.core.support.primitive.StringSupport;
import com.covisint.platform.oauth.client.token.sdk.AuthConfigurationProvider;
import com.covisint.platform.oauth.client.token.sdk.DefaultAuthConfigurationProvider;
import com.covisint.platform.oauth.client.token.sdk.TokenSupplier;
import com.covisint.platform.service.client.service.request.ServicePackageRequestClientFactory;
import com.covisint.platform.service.client.service.request.ServicePackageRequestClientImpl;
import com.covisint.platform.service.core.service.RequestorType;
import com.covisint.platform.service.core.service.request.ServicePackageRequest;
import com.google.common.base.Supplier;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.CheckedFuture;
import java.util.List;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;

public class ServicePackageRequestSDK
extends ServicePackageRequestClientFactory {
    private AuthConfigurationProvider authConfigProvider;

    public ServicePackageRequestSDK(@Nonnull @NotEmpty String serviceUrl) {
        super(serviceUrl);
    }

    @Nonnull
    protected AuthConfigurationProvider getAuthConfigProvider() {
        if (this.authConfigProvider == null) {
            this.authConfigProvider = new DefaultAuthConfigurationProvider();
        }
        return this.authConfigProvider;
    }

    protected HttpClientBuilder populateHttpClientBuilder(@Nonnull HttpClientBuilder builder) {
        TokenSupplier tokenSupplier = new TokenSupplier(this.getAuthConfigProvider());
        builder.addAuthorizationTokenInterceptor((Supplier)tokenSupplier);
        return builder;
    }

    public ServicePackageRequestSDK setAuthConfigProvider(@Nonnull AuthConfigurationProvider provider) {
        this.authConfigProvider = provider;
        return this;
    }

    public ServicePackageRequestClientImpl create() {
        throw new UnsupportedOperationException("Please use #newClient to create new client instances.");
    }

    @Nonnull
    public ServicePackageRequestClient newClient() {
        return new ClientImpl((ServicePackageRequestClientImpl)super.create());
    }

    private static final class ClientImpl
    implements ServicePackageRequestClient {
        private final ServicePackageRequestClientImpl delegate;

        private ClientImpl(@Nonnull ServicePackageRequestClientImpl newDelegate) {
            this.delegate = newDelegate;
        }

        @Override
        @Nonnull
        public CheckedFuture<ServicePackageRequest, ServiceException> get(@Nonnull @NotEmpty String requestId) {
            return this.delegate.get(requestId, (HttpContext)new BasicHttpContext());
        }

        @Override
        @Nonnull
        public CheckedFuture<ServicePackageRequest, ServiceException> add(@Nonnull ServicePackageRequest request) {
            return this.delegate.add((Resource)request, (HttpContext)new BasicHttpContext());
        }

        @Override
        @Nonnull
        public CheckedFuture<ServicePackageRequest, ServiceException> delete(@Nonnull @NotEmpty String requestId) {
            return this.delegate.delete(requestId, (HttpContext)new BasicHttpContext());
        }

        @Override
        @Nonnull
        public CheckedFuture<List<ServicePackageRequest>, ServiceException> search(String requestorId, RequestorType requestorType, @Nonnull Page page) {
            ArrayListMultimap searchCriteria = ArrayListMultimap.create();
            if (StringSupport.trimOrNull((String)requestorId) != null) {
                searchCriteria.put((Object)"requestor.id", (Object)requestorId);
            }
            if (requestorType != null) {
                searchCriteria.put((Object)"requestor.type", (Object)requestorType.toString());
            }
            return this.delegate.search((Multimap)searchCriteria, SortCriteria.NONE, page, (HttpContext)new BasicHttpContext());
        }

        @Override
        @Nonnull
        public CheckedFuture<Void, ServiceException> approve(@Nonnull @NotEmpty String requestId, String justification) {
            return null;
        }

        @Override
        @Nonnull
        public CheckedFuture<Void, ServiceException> deny(@Nonnull @NotEmpty String requestId, String justification) {
            return null;
        }
    }

    public static interface ServicePackageRequestClient {
        @Nonnull
        public CheckedFuture<ServicePackageRequest, ServiceException> get(@Nonnull @NotEmpty String var1);

        @Nonnull
        public CheckedFuture<ServicePackageRequest, ServiceException> add(@Nonnull ServicePackageRequest var1);

        @Nonnull
        public CheckedFuture<ServicePackageRequest, ServiceException> delete(@Nonnull @NotEmpty String var1);

        @Nonnull
        public CheckedFuture<List<ServicePackageRequest>, ServiceException> search(String var1, RequestorType var2, @Nonnull Page var3);

        @Nonnull
        public CheckedFuture<Void, ServiceException> approve(@Nonnull @NotEmpty String var1, String var2);

        @Nonnull
        public CheckedFuture<Void, ServiceException> deny(@Nonnull @NotEmpty String var1, String var2);
    }
}

