/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.service.client.sdk;

import com.covisint.core.http.service.core.Page;
import com.covisint.core.http.service.core.Resource;
import com.covisint.core.http.service.core.ServiceException;
import com.covisint.core.http.service.core.SortCriteria;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NotEmpty;
import com.covisint.core.support.httpclient.HttpClientBuilder;
import com.covisint.core.support.primitive.StringSupport;
import com.covisint.platform.oauth.client.token.sdk.AuthConfigurationProvider;
import com.covisint.platform.oauth.client.token.sdk.DefaultAuthConfigurationProvider;
import com.covisint.platform.oauth.client.token.sdk.TokenSupplier;
import com.covisint.platform.service.client.service.ServicePackageClientFactory;
import com.covisint.platform.service.client.service.ServicePackageClientImpl;
import com.covisint.platform.service.core.service.ServicePackage;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.CheckedFuture;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;

public class ServicePackageSDK
extends ServicePackageClientFactory {
    private AuthConfigurationProvider authConfigProvider;

    public ServicePackageSDK(@Nonnull @NotEmpty String serviceUrl) {
        super(serviceUrl);
    }

    @Nonnull
    protected AuthConfigurationProvider getAuthConfigProvider() {
        if (this.authConfigProvider == null) {
            this.authConfigProvider = new DefaultAuthConfigurationProvider();
        }
        return this.authConfigProvider;
    }

    protected HttpClientBuilder populateHttpClientBuilder(@Nonnull HttpClientBuilder builder) {
        TokenSupplier tokenSupplier = new TokenSupplier(this.getAuthConfigProvider());
        builder.addAuthorizationTokenInterceptor((Supplier)tokenSupplier);
        return builder;
    }

    public ServicePackageSDK setAuthConfigProvider(@Nonnull AuthConfigurationProvider provider) {
        this.authConfigProvider = provider;
        return this;
    }

    public ServicePackageClientImpl create() {
        throw new UnsupportedOperationException("Please use #newClient to create new client instances.");
    }

    @Nonnull
    public ServicePackageClient newClient() {
        return new ClientImpl((ServicePackageClientImpl)super.create());
    }

    private static final class ClientImpl
    implements ServicePackageClient {
        private final ServicePackageClientImpl delegate;

        private ClientImpl(@Nonnull ServicePackageClientImpl newDelegate) {
            this.delegate = newDelegate;
        }

        private void putAllIfNotNull(Multimap<String, String> multimap, String key, Collection<String> collection) {
            if (collection != null && !collection.isEmpty()) {
                multimap.putAll((Object)key, Iterables.filter(collection, (Predicate)Predicates.notNull()));
            }
        }

        private SortCriteria buildSortCriteria(ServicePackageClient.Sort ... sortOrder) {
            SortCriteria.Builder sortBuilder = SortCriteria.builder();
            if (sortOrder != null) {
                for (ServicePackageClient.Sort item : sortOrder) {
                    if (item == null) continue;
                    sortBuilder.parseSortField(item.toString());
                }
            }
            return sortBuilder.build();
        }

        @Override
        @Nonnull
        public CheckedFuture<List<ServicePackage>, ServiceException> search(ServicePackageClient.FilterSpec filter, @Nonnull Page page, ServicePackageClient.Sort ... sortOrder) {
            ArrayListMultimap searchCriteria = ArrayListMultimap.create();
            if (filter != null) {
                this.putAllIfNotNull((Multimap<String, String>)searchCriteria, "id", filter.ids);
                this.putAllIfNotNull((Multimap<String, String>)searchCriteria, "name", filter.names);
                this.putAllIfNotNull((Multimap<String, String>)searchCriteria, "description", filter.descriptions);
                this.putAllIfNotNull((Multimap<String, String>)searchCriteria, "category", filter.categories);
                if (StringSupport.trimOrNull((String)filter.owningOrganizationId) != null) {
                    searchCriteria.put((Object)"owningOrganization.id", (Object)filter.owningOrganizationId);
                }
                if (StringSupport.trimOrNull((String)filter.parentPackageId) != null) {
                    searchCriteria.put((Object)"parentPackage.id", (Object)filter.parentPackageId);
                }
                if (filter.requestablePackages != null) {
                    searchCriteria.put((Object)"requestable", (Object)filter.requestablePackages.toString());
                }
                if (filter.grantablePackages != null) {
                    searchCriteria.put((Object)"grantable", (Object)filter.grantablePackages.toString());
                }
            }
            return this.delegate.search((Multimap)searchCriteria, this.buildSortCriteria(sortOrder), page, (HttpContext)new BasicHttpContext());
        }

        @Override
        @Nonnull
        public CheckedFuture<ServicePackage, ServiceException> add(@Nonnull ServicePackage servicePackage) {
            return this.delegate.add((Resource)servicePackage, (HttpContext)new BasicHttpContext());
        }

        @Override
        @Nonnull
        public CheckedFuture<ServicePackage, ServiceException> get(@Nonnull @NotEmpty String packageId) {
            return this.delegate.get(packageId, (HttpContext)new BasicHttpContext());
        }
    }

    public static interface ServicePackageClient {
        @Nonnull
        public CheckedFuture<List<ServicePackage>, ServiceException> search(FilterSpec var1, @Nonnull Page var2, Sort ... var3);

        @Nonnull
        public CheckedFuture<ServicePackage, ServiceException> add(@Nonnull ServicePackage var1);

        @Nonnull
        public CheckedFuture<ServicePackage, ServiceException> get(@Nonnull @NotEmpty String var1);

        public static final class FilterSpec {
            private Collection<String> ids;
            private Collection<String> names;
            private Collection<String> descriptions;
            private Collection<String> categories;
            private Boolean grantablePackages;
            private Boolean requestablePackages;
            private String owningOrganizationId;
            private String parentPackageId;

            public FilterSpec setIds(String ... newIds) {
                this.ids = Arrays.asList(newIds);
                return this;
            }

            public FilterSpec setNames(String ... newNames) {
                this.names = Arrays.asList(newNames);
                return this;
            }

            public FilterSpec setDescriptions(String ... newDescriptions) {
                this.descriptions = Arrays.asList(newDescriptions);
                return this;
            }

            public FilterSpec setCategories(String ... newCategories) {
                this.categories = Arrays.asList(newCategories);
                return this;
            }

            public FilterSpec setGrantablePackages(Boolean grantable) {
                this.grantablePackages = grantable;
                return this;
            }

            public FilterSpec setRequestablePackages(Boolean requestable) {
                this.requestablePackages = requestable;
                return this;
            }

            public FilterSpec setOwningOrganizationId(String id) {
                this.owningOrganizationId = id;
                return this;
            }

            public FilterSpec setParentPackageId(String id) {
                this.parentPackageId = id;
                return this;
            }

            public String toString() {
                return Objects.toStringHelper((Object)this).add("ids", this.ids).add("names", this.names).add("descriptions", this.descriptions).add("categories", this.categories).add("grantablePackages", (Object)this.grantablePackages).add("requestablePackages", (Object)this.requestablePackages).add("owningOrganizationId", (Object)this.owningOrganizationId).add("parentPackageId", (Object)this.parentPackageId).toString();
            }

            public int hashCode() {
                return Objects.hashCode((Object[])new Object[]{this.ids, this.names, this.descriptions, this.categories, this.parentPackageId, this.owningOrganizationId, this.requestablePackages, this.grantablePackages});
            }

            public boolean equals(Object obj) {
                if (obj == this) {
                    return true;
                }
                if (!(obj instanceof FilterSpec)) {
                    return false;
                }
                FilterSpec other = (FilterSpec)obj;
                return Objects.equal(this.ids, other.ids) && Objects.equal(this.names, other.names) && Objects.equal(this.descriptions, other.descriptions) && Objects.equal(this.categories, other.categories) && Objects.equal((Object)this.owningOrganizationId, (Object)other.owningOrganizationId) && Objects.equal((Object)this.parentPackageId, (Object)other.parentPackageId) && Objects.equal((Object)this.grantablePackages, (Object)other.grantablePackages) && Objects.equal((Object)this.requestablePackages, (Object)other.requestablePackages);
            }
        }

        public static enum Sort {
            CREATION_ASC("+creation"),
            CREATION_DESC("-creation");

            private final String id;

            private Sort(String newId) {
                this.id = newId;
            }

            public String toString() {
                return this.id;
            }
        }
    }
}

