/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.service.client.service.grant;

import com.covisint.core.http.service.client.BaseResourceClientBuilder;
import com.covisint.core.http.service.client.ClientException;
import com.covisint.platform.service.client.service.grant.ServicePackageGrantClientImpl;
import com.damnhandy.uri.template.MalformedUriTemplateException;
import com.damnhandy.uri.template.UriTemplate;
import com.damnhandy.uri.template.UriTemplateBuilder;
import com.damnhandy.uri.template.impl.VarSpec;
import com.google.common.net.MediaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServicePackageGrantClientBuilder
extends BaseResourceClientBuilder<ServicePackageGrantClientBuilder, ServicePackageGrantClientImpl> {
    private final Logger log = LoggerFactory.getLogger(ServicePackageGrantClientBuilder.class);

    protected String getResourceCollectionPath() {
        return "/";
    }

    protected MediaType getResourceRepresentation() {
        return ServicePackageGrantClientImpl.SERVICE_PACKAGE_GRANT_MT;
    }

    public ServicePackageGrantClientImpl build() {
        ServicePackageGrantClientImpl impl = (ServicePackageGrantClientImpl)this.populateBaseBuilder(new ServicePackageGrantClientImpl());
        try {
            UriTemplate personPackageGrantsCollectionUri = UriTemplate.buildFromTemplate((String)this.getServiceBaseUrl()).literal("/persons").path(new VarSpec[]{UriTemplateBuilder.var((String)"personId")}).literal("/packages").build();
            impl.setPersonPackageGrantsCollectionUriTemplate(personPackageGrantsCollectionUri);
            UriTemplate organizationPackageGrantsCollectionUri = UriTemplate.buildFromTemplate((String)this.getServiceBaseUrl()).literal("/organizations").path(new VarSpec[]{UriTemplateBuilder.var((String)"organizationId")}).literal("/packages").build();
            impl.setOrganizationPackageGrantsCollectionUriTemplate(organizationPackageGrantsCollectionUri);
            UriTemplate personPackageGrantUri = UriTemplate.buildFromTemplate((UriTemplate)personPackageGrantsCollectionUri).path(new VarSpec[]{UriTemplateBuilder.var((String)"packageId")}).build();
            impl.setPersonPackageGrantUriTemplate(personPackageGrantUri);
            UriTemplate organizationPackageGrantUri = UriTemplate.buildFromTemplate((UriTemplate)organizationPackageGrantsCollectionUri).path(new VarSpec[]{UriTemplateBuilder.var((String)"packageId")}).build();
            impl.setOrganizationPackageGrantUriTemplate(organizationPackageGrantUri);
            UriTemplate packageGrantCollectionUriTemplate = UriTemplate.buildFromTemplate((String)this.getServiceBaseUrl()).literal("/grants").build();
            impl.setPackageGrantCollectionUriTemplate(packageGrantCollectionUriTemplate);
        }
        catch (MalformedUriTemplateException e) {
            this.log.error("Error occurred while expanding URL template.", (Throwable)e);
            throw new ClientException("Error occurred while expanding URL template.");
        }
        return impl;
    }
}

