/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.oauth.core.domain;

import com.covisint.core.http.service.core.AbstractRealmScopedResource;
import com.covisint.core.http.service.core.Resource;
import com.covisint.core.support.constraint.Nullable;
import com.covisint.core.support.constraint.Searchable;
import com.covisint.platform.oauth.core.domain.Subject;
import com.google.common.base.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.PostLoad;
import javax.persistence.Transient;

@Entity
public abstract class AbstractGrantType<T extends Resource>
extends AbstractRealmScopedResource<AbstractGrantType> {
    private static final long serialVersionUID = 1906833175573493317L;
    @Column(name="grant_type", columnDefinition="varchar2(64)", nullable=false)
    @Searchable
    private String type;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="SUBJECT_ID", referencedColumnName="ID", nullable=false)
    private Subject subjectResource;
    @Column(name="APP_ID", length=64)
    private String appId;
    @Transient
    private String subject;

    protected Objects.ToStringHelper populateToStringHelper(Objects.ToStringHelper helper) {
        return super.populateToStringHelper(helper).add("type", (Object)this.getType()).add("appId", (Object)this.getAppId());
    }

    @Nullable
    public String getType() {
        return this.type;
    }

    public AbstractGrantType setType(String grant) {
        this.type = grant;
        return this;
    }

    @Nullable
    public Subject getSubject() {
        return this.subjectResource;
    }

    public AbstractGrantType setSubject(Subject sub) {
        this.subjectResource = sub;
        if (this.subjectResource != null) {
            this.subject = this.subjectResource.getId();
        }
        return this;
    }

    public AbstractGrantType setAppId(String applicationId) {
        this.appId = applicationId;
        return this;
    }

    @Nullable
    public String getAppId() {
        return this.appId;
    }

    public AbstractGrantType setSubjectId(String id) {
        this.subject = id;
        return this;
    }

    @Nullable
    public String getSubjectId() {
        return this.subject;
    }

    @PostLoad
    public void postLoad() {
        if (this.subjectResource != null) {
            this.subject = this.subjectResource.getId();
        }
    }
}

