/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.oauth.core.granttype.clientsecret.io.json;

import com.covisint.core.http.service.core.io.jsonp.AbstractRealmScopedResourceReader;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.Nullable;
import com.covisint.platform.oauth.core.JsonpSupport;
import com.covisint.platform.oauth.core.SupportedMediaType;
import com.covisint.platform.oauth.core.domain.AbstractGrantType;
import com.covisint.platform.oauth.core.domain.ClientSecretGrantType;
import com.covisint.platform.oauth.core.domain.Subject;
import com.google.common.net.MediaType;
import javax.json.JsonObject;
import javax.json.JsonString;

public class ClientSecretGrantTypeReader
extends AbstractRealmScopedResourceReader<ClientSecretGrantType> {
    private void readClientSecret(@Nonnull JsonObject src, @Nonnull ClientSecretGrantType grantType) {
        JsonString stringValue = src.getJsonString("clientSecret");
        if (!com.covisint.core.http.service.core.io.jsonp.JsonpSupport.isJsonStringPropertyEmptyOrNull((JsonString)stringValue)) {
            grantType.setClientSecret(stringValue.getString());
        }
    }

    private void readSubject(@Nonnull JsonObject src, @Nonnull ClientSecretGrantType grantType) {
        JsonString stringValue = src.getJsonString("subjectId");
        if (!com.covisint.core.http.service.core.io.jsonp.JsonpSupport.isJsonStringPropertyEmptyOrNull((JsonString)stringValue)) {
            String subjectId = stringValue.getString();
            grantType.setSubjectId(subjectId);
            grantType.setSubject((Subject)new Subject().setId(subjectId));
        }
    }

    private void readAppId(@Nonnull JsonObject src, @Nonnull ClientSecretGrantType grantType) {
        JsonString stringValue = src.getJsonString("applicationId");
        if (!com.covisint.core.http.service.core.io.jsonp.JsonpSupport.isJsonStringPropertyEmptyOrNull((JsonString)stringValue)) {
            grantType.setAppId(stringValue.getString());
        }
    }

    @Nullable
    protected ClientSecretGrantType readResource(@Nonnull MediaType mediaType, @Nonnull JsonObject json) {
        ClientSecretGrantType grantType = (ClientSecretGrantType)super.readResource(mediaType, json);
        grantType.setType("client_credentials");
        this.readClientSecret(json, grantType);
        this.readSubject(json, grantType);
        this.readAppId(json, grantType);
        return grantType;
    }

    @Nonnull
    protected ClientSecretGrantType createResource(@Nonnull MediaType mediaType) {
        return new ClientSecretGrantType();
    }

    public boolean isReadable(@Nonnull MediaType mediaType) {
        return JsonpSupport.isMediaTypeSame(SupportedMediaType.CLIENT_SECRET_GRANT_MT, mediaType);
    }

    @Nonnull
    public Class getResourceType() {
        return AbstractGrantType.class;
    }
}

