/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.service.core.service;

import com.covisint.core.http.service.core.io.jsonp.JsonpSupport;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NonnullElements;
import com.covisint.core.support.constraint.NotEmpty;
import com.covisint.platform.service.core.service.SupportedMediaType;
import com.google.common.net.MediaType;
import java.util.HashMap;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonString;
import javax.json.JsonValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServiceJsonpSupport {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceJsonpSupport.class);

    private ServiceJsonpSupport() {
    }

    public static Map<String, String> readMap(@Nonnull JsonObject json, @Nonnull @NotEmpty String mapPropertyName, @Nonnull @NotEmpty String keyPropertyName, @Nonnull @NotEmpty String valuePropertyName) {
        HashMap<String, String> map = new HashMap<String, String>();
        JsonArray jsonArray = json.getJsonArray(mapPropertyName);
        if (jsonArray == null) {
            return map;
        }
        for (JsonValue value : jsonArray) {
            if (!JsonpSupport.isObject((JsonValue)value)) {
                LOG.debug("Found array item not of type 'object', but {}.  Skipping it.", (Object)value.getValueType());
                continue;
            }
            JsonObject jsonObject = (JsonObject)value;
            JsonString jsonString = jsonObject.getJsonString(keyPropertyName);
            if (JsonpSupport.isJsonStringPropertyEmptyOrNull((JsonString)jsonString)) {
                LOG.warn("Expected key property '{}'.  Skipping entry.", (Object)keyPropertyName);
                continue;
            }
            String lang = jsonString.getString();
            jsonString = jsonObject.getJsonString(valuePropertyName);
            if (JsonpSupport.isJsonStringPropertyEmptyOrNull((JsonString)jsonString)) {
                LOG.warn("Expected value property '{}'.  Skipping entry.", (Object)valuePropertyName);
                continue;
            }
            String text = jsonString.getString();
            map.put(lang, text);
        }
        return map;
    }

    public static void writeMap(@Nonnull JsonObjectBuilder builder, @Nonnull @NonnullElements Map<String, String> map, @Nonnull @NotEmpty String mapPropertyName, @Nonnull @NotEmpty String keyPropertyName, @Nonnull @NotEmpty String valuePropertyName) {
        if (map.isEmpty()) {
            return;
        }
        JsonArrayBuilder jsonArray = Json.createArrayBuilder();
        for (Map.Entry<String, String> e : map.entrySet()) {
            JsonObjectBuilder jsonObject = Json.createObjectBuilder();
            JsonpSupport.addPropertyIfNonnullValue((JsonObjectBuilder)jsonObject, (String)keyPropertyName, (String)e.getKey());
            JsonpSupport.addPropertyIfNonnullValue((JsonObjectBuilder)jsonObject, (String)valuePropertyName, (String)e.getValue());
            jsonArray.add(jsonObject);
        }
        builder.add(mapPropertyName, jsonArray);
    }

    public static boolean isMediaTypeSame(@Nonnull SupportedMediaType mt1, @Nonnull MediaType mt2) {
        return mt1.value().equals(mt2.withoutParameters().toString());
    }
}

