/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.service.core.service;

import com.covisint.core.http.service.core.AbstractRealmScopedResource;
import com.covisint.core.http.service.core.ResourceReference;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NonnullElements;
import com.covisint.core.support.constraint.NotEmpty;
import com.covisint.core.support.constraint.Nullable;
import com.covisint.core.support.constraint.NullableElements;
import com.covisint.core.support.constraint.Searchable;
import com.covisint.core.support.primitive.StringSupport;
import com.covisint.platform.service.core.service.CodeRestriction;
import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class ServicePackage
extends AbstractRealmScopedResource<ServicePackage> {
    private static final long serialVersionUID = -2910972999762507300L;
    @Searchable
    private ResourceReference owningOrganization;
    @Searchable
    private ResourceReference parentPackage;
    private List<CodeRestriction> codeRestrictions = new ArrayList<CodeRestriction>();
    private Map<String, String> termsAndConditions = new HashMap<String, String>();
    private boolean protectionEnabled;
    @Searchable(name="requestable")
    private boolean requestsEnabled;
    @Searchable(name="grantable")
    private boolean grantsEnabled = true;
    private boolean displayEnabled = true;
    private String defaultName;
    private Long packageId;
    @Searchable(name="name")
    private Map<String, String> names = new HashMap<String, String>();
    @Searchable(name="description")
    private Map<String, String> descriptions = new HashMap<String, String>();
    @Searchable(name="category")
    private Map<String, String> categories = new HashMap<String, String>();
    private boolean organizationAdminApprovalRequired;
    private boolean applicationAdminApprovalRequired;
    private boolean provisioningAdminApprovalRequired;
    private boolean userRequestReasonRequired;

    @Nullable
    public ResourceReference getParentPackage() {
        return this.parentPackage;
    }

    public ServicePackage setParentPackage(@Nonnull ResourceReference ref) {
        this.parentPackage = ref;
        return this;
    }

    @Nonnull
    public ServicePackage setParentPackageId(@Nonnull @NotEmpty String parentPackageId) {
        this.parentPackage = new ResourceReference(parentPackageId, "servicePackage");
        return this;
    }

    @Nonnull
    @NullableElements
    public Map<String, String> getNames() {
        return Collections.unmodifiableMap(this.names);
    }

    @Nonnull
    @NullableElements
    public Map<String, String> getDescriptions() {
        return Collections.unmodifiableMap(this.descriptions);
    }

    @Nullable
    public String getDefaultName() {
        if (this.defaultName != null) {
            return this.defaultName;
        }
        String en = Locale.ENGLISH.getLanguage();
        if (this.names.containsKey(en)) {
            return this.names.get(en);
        }
        return null;
    }

    @Nonnull
    public ServicePackage setDefaultName(@Nonnull @NotEmpty String name) {
        this.defaultName = name;
        this.names.put(Locale.ENGLISH.getLanguage(), name);
        return this;
    }

    @Nonnull
    public ServicePackage setNames(Map<String, String> newNames) {
        this.names = new HashMap<String, String>();
        if (newNames != null) {
            for (Map.Entry<String, String> name : newNames.entrySet()) {
                String trimmedName = StringSupport.trimOrNull((String)name.getValue());
                if (trimmedName == null) continue;
                this.names.put(name.getKey(), trimmedName);
            }
        }
        return this;
    }

    @Nonnull
    public ServicePackage addName(@Nonnull @NotEmpty String lang, @Nonnull @NotEmpty String name) {
        this.names.put(lang, StringSupport.trim((String)name));
        return this;
    }

    @Nonnull
    public ServicePackage addDescription(@Nonnull @NotEmpty String lang, @Nonnull @NotEmpty String description) {
        this.descriptions.put(lang, StringSupport.trim((String)description));
        return this;
    }

    @Nonnull
    public ServicePackage setDescriptions(Map<String, String> newDescriptions) {
        this.descriptions = new HashMap<String, String>();
        if (newDescriptions != null) {
            for (Map.Entry<String, String> description : newDescriptions.entrySet()) {
                String trimmedDesc = StringSupport.trimOrNull((String)description.getValue());
                if (trimmedDesc == null) continue;
                this.descriptions.put(description.getKey(), trimmedDesc);
            }
        }
        return this;
    }

    @Nonnull
    @NullableElements
    public Map<String, String> getCategories() {
        return Collections.unmodifiableMap(this.categories);
    }

    @Nonnull
    public ServicePackage setCategories(@Nonnull @NotEmpty Map<String, String> newCategories) {
        this.categories = new HashMap<String, String>();
        if (newCategories != null) {
            for (Map.Entry<String, String> category : newCategories.entrySet()) {
                String trimmedUrl = StringSupport.trimOrNull((String)category.getValue());
                if (trimmedUrl == null) continue;
                this.categories.put(category.getKey(), trimmedUrl);
            }
        }
        return this;
    }

    @Nonnull
    public ServicePackage addCategory(@Nonnull @NotEmpty String lang, @Nonnull @NotEmpty String text) {
        this.categories.put(lang, StringSupport.trim((String)text));
        return this;
    }

    @Nullable
    public ResourceReference getOwningOrganization() {
        return this.owningOrganization;
    }

    @Nonnull
    public ServicePackage setOwningOrganization(@Nonnull ResourceReference ref) {
        this.owningOrganization = ref;
        return this;
    }

    @Nonnull
    public ServicePackage setOwningOrganizationId(@Nonnull @NotEmpty String organizationId) {
        this.owningOrganization = new ResourceReference(organizationId, "organization");
        return this;
    }

    @Nonnull
    @NullableElements
    public Map<String, String> getTermsAndConditions() {
        return Collections.unmodifiableMap(this.termsAndConditions);
    }

    @Nonnull
    public ServicePackage setTermsAndConditions(@Nonnull Map<String, String> tac) {
        this.termsAndConditions = new HashMap<String, String>(tac);
        return this;
    }

    @Nonnull
    public ServicePackage addTermsAndConditions(@Nonnull @NotEmpty String type, @Nonnull @NotEmpty String text) {
        this.termsAndConditions.put(type, StringSupport.trim((String)text));
        return this;
    }

    @Nonnull
    @NullableElements
    public List<CodeRestriction> getCodeRestrictions() {
        return Collections.unmodifiableList(this.codeRestrictions);
    }

    @Nonnull
    public ServicePackage setCodeRestriction(@Nonnull @NonnullElements List<CodeRestriction> restrictions) {
        this.codeRestrictions = new ArrayList<CodeRestriction>(restrictions);
        return this;
    }

    @Nonnull
    public ServicePackage addCodeRestriction(@Nonnull CodeRestriction restriction) {
        this.codeRestrictions.add(restriction);
        return this;
    }

    public boolean isProtectionEnabled() {
        return this.protectionEnabled;
    }

    @Nonnull
    public ServicePackage setProtectionEnabled(boolean enabled) {
        this.protectionEnabled = enabled;
        return this;
    }

    public boolean isRequestsEnabled() {
        return this.requestsEnabled;
    }

    @Nonnull
    public ServicePackage setRequestsEnabled(boolean enabled) {
        this.requestsEnabled = enabled;
        return this;
    }

    public boolean isGrantsEnabled() {
        return this.grantsEnabled;
    }

    @Nonnull
    public ServicePackage setGrantsEnabled(boolean enabled) {
        this.grantsEnabled = enabled;
        return this;
    }

    public boolean isDisplayEnabled() {
        return this.displayEnabled;
    }

    @Nonnull
    public ServicePackage setDisplayEnabled(boolean enabled) {
        this.displayEnabled = enabled;
        return this;
    }

    public boolean isOrganizationAdminApprovalRequired() {
        return this.organizationAdminApprovalRequired;
    }

    @Nonnull
    public ServicePackage setOrganizationAdminApprovalRequired(boolean required) {
        this.organizationAdminApprovalRequired = required;
        return this;
    }

    public boolean isApplicationAdminApprovalRequired() {
        return this.applicationAdminApprovalRequired;
    }

    @Nonnull
    public ServicePackage setApplicationAdminApprovalRequired(boolean required) {
        this.applicationAdminApprovalRequired = required;
        return this;
    }

    public boolean isProvisioningAdminApprovalRequired() {
        return this.provisioningAdminApprovalRequired;
    }

    @Nonnull
    public ServicePackage setProvisioningAdminApprovalRequired(boolean required) {
        this.provisioningAdminApprovalRequired = required;
        return this;
    }

    public boolean isUserRequestReasonRequired() {
        return this.userRequestReasonRequired;
    }

    @Nonnull
    public ServicePackage setUserRequestReasonRequired(boolean required) {
        this.userRequestReasonRequired = required;
        return this;
    }

    @Nonnull
    public Long getPackageId() {
        return this.packageId;
    }

    public ServicePackage setPackageId(@Nonnull Long newPackageId) {
        this.packageId = newPackageId;
        return this;
    }

    public boolean equals(Object obj) {
        return this.isResourceIdentityEqual(ServicePackage.class, obj);
    }

    public int hashCode() {
        return this.getResourceIdentityHashCode();
    }

    public String toString() {
        return this.populateToStringHelper(Objects.toStringHelper(ServicePackage.class)).add("owningOrganization", (Object)this.owningOrganization).add("parentPackage", (Object)this.parentPackage).add("termsAndConditions", this.termsAndConditions).add("restrictions", this.codeRestrictions).add("protectionEnabled", this.protectionEnabled).add("requestsEnabled", this.requestsEnabled).add("grantsEnabled", this.grantsEnabled).add("displayEnabled", this.displayEnabled).add("defaultName", (Object)this.getDefaultName()).add("name", this.names).add("description", this.descriptions).add("category", this.categories).add("organizationAdminApprovalRequired", this.organizationAdminApprovalRequired).add("applicationAdminApprovalRequired", this.applicationAdminApprovalRequired).add("provisioningAdminApprovalRequired", this.provisioningAdminApprovalRequired).add("userRequestReasonRequired", this.userRequestReasonRequired).add("packageId", (Object)this.packageId).toString();
    }
}

