/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.service.core.service.grant.io.jsonp;

import com.covisint.core.http.service.core.ResourceReference;
import com.covisint.core.http.service.core.io.jsonp.AbstractRealmScopedResourceReader;
import com.covisint.core.http.service.core.io.jsonp.JsonpSupport;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.platform.service.core.service.ServiceJsonpSupport;
import com.covisint.platform.service.core.service.SupportedMediaType;
import com.covisint.platform.service.core.service.grant.GrantStatus;
import com.covisint.platform.service.core.service.grant.ServicePackageGrant;
import com.google.common.base.Enums;
import com.google.common.base.Optional;
import com.google.common.net.MediaType;
import javax.json.JsonObject;
import javax.json.JsonString;

public class ServicePackageGrantReader
extends AbstractRealmScopedResourceReader<ServicePackageGrant> {
    private void readStatus(@Nonnull JsonObject json, @Nonnull ServicePackageGrant grant) {
        JsonString jsonString = json.getJsonString("status");
        if (!JsonpSupport.isJsonStringPropertyEmptyOrNull((JsonString)jsonString)) {
            Optional status = Enums.getIfPresent(GrantStatus.class, (String)jsonString.getString().toUpperCase());
            if (!status.isPresent()) {
                grant.setStatus(GrantStatus.INVALID);
                return;
            }
            grant.setStatus((GrantStatus)((Object)status.get()));
        }
    }

    private void readGrantee(@Nonnull JsonObject json, @Nonnull ServicePackageGrant grant) {
        ResourceReference granteeRef = ServicePackageGrantReader.readResourceReference((JsonObject)json.getJsonObject("grantee"));
        if (granteeRef != null) {
            grant.setGrantee(granteeRef);
        }
    }

    private void readServicePackage(@Nonnull JsonObject json, @Nonnull ServicePackageGrant grant) {
        ResourceReference packageRef = ServicePackageGrantReader.readResourceReference((JsonObject)json.getJsonObject("servicePackage"));
        if (packageRef != null) {
            grant.setServicePackage(packageRef);
        }
    }

    @Nonnull
    protected ServicePackageGrant createResource(@Nonnull MediaType mediaType) {
        return new ServicePackageGrant();
    }

    @Nonnull
    protected ServicePackageGrant readResource(@Nonnull MediaType mediaType, @Nonnull JsonObject json) {
        ServicePackageGrant grant = (ServicePackageGrant)super.readResource(mediaType, json);
        this.readStatus(json, grant);
        this.readGrantee(json, grant);
        this.readServicePackage(json, grant);
        return grant;
    }

    @Nonnull
    public Class<ServicePackageGrant> getResourceType() {
        return ServicePackageGrant.class;
    }

    public boolean isReadable(@Nonnull MediaType mediaType) {
        return ServiceJsonpSupport.isMediaTypeSame(SupportedMediaType.SERVICE_PACKAGE_GRANT_MT, mediaType);
    }
}

