/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.service.core.service.grant.io.jsonp;

import com.covisint.core.http.service.core.AbstractRealmScopedResource;
import com.covisint.core.http.service.core.io.jsonp.AbstractRealmScopedResourceWriter;
import com.covisint.core.http.service.core.io.jsonp.JsonpSupport;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.platform.service.core.service.ServiceJsonpSupport;
import com.covisint.platform.service.core.service.SupportedMediaType;
import com.covisint.platform.service.core.service.grant.ServicePackageGrant;
import com.google.common.net.MediaType;
import javax.json.JsonObjectBuilder;

public class ServicePackageGrantWriter
extends AbstractRealmScopedResourceWriter<ServicePackageGrant> {
    @Nonnull
    protected JsonObjectBuilder writeResource(@Nonnull MediaType mediaType, @Nonnull ServicePackageGrant grant) {
        JsonObjectBuilder root = super.writeResource(mediaType, (AbstractRealmScopedResource)grant);
        JsonpSupport.addPropertyIfNonnullValue((JsonObjectBuilder)root, (String)"status", (String)grant.getStatus().toString().toLowerCase());
        if (grant.getGrantee() != null) {
            this.writeResourceReference("grantee", grant.getGrantee(), root);
        }
        if (grant.getServicePackage() != null) {
            this.writeResourceReference("servicePackage", grant.getServicePackage(), root);
        }
        return root;
    }

    @Nonnull
    public Class<ServicePackageGrant> getResourceType() {
        return ServicePackageGrant.class;
    }

    public boolean isWritable(@Nonnull Class klass, @Nonnull MediaType mediaType) {
        return ServiceJsonpSupport.isMediaTypeSame(SupportedMediaType.SERVICE_PACKAGE_GRANT_MT, mediaType);
    }
}

