/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.service.core.service.io.jsonp;

import com.covisint.core.http.service.core.AbstractRealmScopedResource;
import com.covisint.core.http.service.core.io.jsonp.AbstractRealmScopedResourceWriter;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.platform.service.core.service.CodeRestriction;
import com.covisint.platform.service.core.service.ServiceJsonpSupport;
import com.covisint.platform.service.core.service.ServicePackage;
import com.covisint.platform.service.core.service.SupportedMediaType;
import com.google.common.net.MediaType;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;

public class ServicePackageWriter
extends AbstractRealmScopedResourceWriter<ServicePackage> {
    private void writeApprovalRequirements(@Nonnull ServicePackage pkg, @Nonnull JsonObjectBuilder builder) {
        JsonArray approvals;
        JsonArrayBuilder approvalsBuilder = Json.createArrayBuilder();
        if (pkg.isOrganizationAdminApprovalRequired()) {
            approvalsBuilder.add("organizationAdmin");
        }
        if (pkg.isApplicationAdminApprovalRequired()) {
            approvalsBuilder.add("applicationAdmin");
        }
        if (pkg.isProvisioningAdminApprovalRequired()) {
            approvalsBuilder.add("provisioningAdmin");
        }
        if (!(approvals = approvalsBuilder.build()).isEmpty()) {
            builder.add("requiredApprovals", (JsonValue)approvals);
        }
    }

    @Nonnull
    protected JsonObjectBuilder writeResource(@Nonnull MediaType mediaType, @Nonnull ServicePackage pkg) {
        JsonObjectBuilder builder = super.writeResource(mediaType, (AbstractRealmScopedResource)pkg);
        ServiceJsonpSupport.writeMap(builder, pkg.getNames(), "name", "lang", "text");
        ServiceJsonpSupport.writeMap(builder, pkg.getDescriptions(), "description", "lang", "text");
        ServiceJsonpSupport.writeMap(builder, pkg.getTermsAndConditions(), "termsAndConditions", "type", "tacId");
        ServiceJsonpSupport.writeMap(builder, pkg.getCategories(), "category", "lang", "text");
        if (pkg.getParentPackage() != null) {
            this.writeResourceReference("parent", pkg.getParentPackage(), builder);
        }
        this.writeResourceReference("owningOrganization", pkg.getOwningOrganization(), builder);
        this.writeApprovalRequirements(pkg, builder);
        if (!pkg.getCodeRestrictions().isEmpty()) {
            JsonArrayBuilder codeRestrictionsJson = Json.createArrayBuilder();
            for (CodeRestriction restriction : pkg.getCodeRestrictions()) {
                JsonObjectBuilder restrictionJson = Json.createObjectBuilder();
                restrictionJson.add("requestorType", restriction.getRequestorType());
                restrictionJson.add("restriction", restriction.getRestriction().toString().toLowerCase());
                codeRestrictionsJson.add(restrictionJson);
            }
            builder.add("codeRestrictions", codeRestrictionsJson);
        }
        builder.add("protected", pkg.isProtectionEnabled());
        builder.add("requestable", pkg.isRequestsEnabled());
        builder.add("grantable", pkg.isGrantsEnabled());
        builder.add("displayable", pkg.isDisplayEnabled());
        builder.add("requestReasonRequired", pkg.isUserRequestReasonRequired());
        return builder;
    }

    @Nonnull
    public Class<ServicePackage> getResourceType() {
        return ServicePackage.class;
    }

    public boolean isWritable(@Nonnull Class klass, @Nonnull MediaType mediaType) {
        return ServiceJsonpSupport.isMediaTypeSame(SupportedMediaType.SERVICE_PACKAGE_MT, mediaType);
    }
}

