/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.service.core.service.io.jsonp;

import com.covisint.core.http.service.core.AbstractRealmScopedResource;
import com.covisint.core.http.service.core.ResourceReference;
import com.covisint.core.http.service.core.io.jsonp.AbstractRealmScopedResourceWriter;
import com.covisint.core.http.service.core.io.jsonp.JsonpSupport;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.platform.service.core.service.Service;
import com.covisint.platform.service.core.service.ServiceJsonpSupport;
import com.covisint.platform.service.core.service.SupportedMediaType;
import com.google.common.net.MediaType;
import javax.json.JsonObjectBuilder;

public class ServiceWriter
extends AbstractRealmScopedResourceWriter<Service> {
    @Nonnull
    protected JsonObjectBuilder writeResource(@Nonnull MediaType mediaType, @Nonnull Service service) {
        JsonObjectBuilder builder = super.writeResource(mediaType, (AbstractRealmScopedResource)service);
        ServiceJsonpSupport.writeMap(builder, service.getNames(), "name", "lang", "text");
        ServiceJsonpSupport.writeMap(builder, service.getDescriptions(), "description", "lang", "text");
        ServiceJsonpSupport.writeMap(builder, service.getCategories(), "category", "lang", "text");
        ServiceJsonpSupport.writeMap(builder, service.getUrls(), "urls", "type", "value");
        if (service.getParentService() != null) {
            this.writeResourceReference("parentService", new ResourceReference(service.getParentService().getId(), "service"), builder);
        }
        this.writeResourceReference("owningOrganization", service.getOwningOrganization(), builder);
        JsonpSupport.addPropertyIfNonnullValue((JsonObjectBuilder)builder, (String)"remoteAppId", (String)service.getRemoteApplicationId());
        JsonpSupport.addPropertyIfNonnullValue((JsonObjectBuilder)builder, (String)"mobileServiceId", (String)service.getMobileServiceId());
        JsonpSupport.addPropertyIfNonnullValue((JsonObjectBuilder)builder, (String)"federationConnectionWizard", (String)service.getFederationConnectionWizard());
        builder.add("protected", service.isProtectionEnabled());
        builder.add("messagingEnabled", service.isMessagingEnabled());
        return builder;
    }

    @Nonnull
    public Class<Service> getResourceType() {
        return Service.class;
    }

    public boolean isWritable(@Nonnull Class klass, @Nonnull MediaType mediaType) {
        return ServiceJsonpSupport.isMediaTypeSame(SupportedMediaType.SERVICE_MT, mediaType);
    }
}

