/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.service.core.service.request.io.jsonp;

import com.covisint.core.http.service.core.ResourceReference;
import com.covisint.core.http.service.core.io.jsonp.AbstractRealmScopedResourceReader;
import com.covisint.core.http.service.core.io.jsonp.JsonpSupport;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.platform.service.core.service.ServiceJsonpSupport;
import com.covisint.platform.service.core.service.SupportedMediaType;
import com.covisint.platform.service.core.service.request.ServicePackageRequest;
import com.google.common.net.MediaType;
import javax.json.JsonObject;
import javax.json.JsonString;

public class ServicePackageRequestReader
extends AbstractRealmScopedResourceReader<ServicePackageRequest> {
    private void readRequestor(@Nonnull JsonObject json, @Nonnull ServicePackageRequest request) {
        JsonObject jsonObject = json.getJsonObject("requestor");
        if (jsonObject == null) {
            return;
        }
        JsonString jsonString = jsonObject.getJsonString("id");
        if (JsonpSupport.isJsonStringPropertyEmptyOrNull((JsonString)jsonString)) {
            return;
        }
        String requestorId = jsonString.getString();
        jsonString = jsonObject.getJsonString("type");
        String requestorType = "person";
        if (!JsonpSupport.isJsonStringPropertyEmptyOrNull((JsonString)jsonString)) {
            requestorType = jsonString.getString();
        }
        request.setRequestor(new ResourceReference(requestorId, requestorType));
    }

    private void readParentRequest(@Nonnull JsonObject json, @Nonnull ServicePackageRequest request) {
        JsonObject jsonObject = json.getJsonObject("prerequisite");
        if (jsonObject == null) {
            return;
        }
        JsonString jsonString = jsonObject.getJsonString("id");
        if (JsonpSupport.isJsonStringPropertyEmptyOrNull((JsonString)jsonString)) {
            return;
        }
        String parentRequestId = jsonString.getString();
        jsonString = jsonObject.getJsonString("type");
        String parentRequestType = "servicePackage";
        if (!JsonpSupport.isJsonStringPropertyEmptyOrNull((JsonString)jsonString)) {
            parentRequestType = jsonString.getString();
        }
        request.setParentRequest(new ResourceReference(parentRequestId, parentRequestType));
    }

    @Nonnull
    protected ServicePackageRequest createResource(@Nonnull MediaType mediaType) {
        return new ServicePackageRequest();
    }

    @Nonnull
    protected ServicePackageRequest readResource(@Nonnull MediaType mediaType, @Nonnull JsonObject json) {
        JsonString jsonString;
        ServicePackageRequest request = (ServicePackageRequest)super.readResource(mediaType, json);
        this.readRequestor(json, request);
        this.readParentRequest(json, request);
        ResourceReference packageRef = ServicePackageRequestReader.readResourceReference((JsonObject)json.getJsonObject("servicePackage"));
        if (packageRef != null) {
            request.setRequestedPackage(new ResourceReference(packageRef.getId(), "servicePackage"));
        }
        if (!JsonpSupport.isJsonStringPropertyEmptyOrNull((JsonString)(jsonString = json.getJsonString("reason")))) {
            request.setReason(jsonString.getString());
        }
        return request;
    }

    @Nonnull
    public Class<ServicePackageRequest> getResourceType() {
        return ServicePackageRequest.class;
    }

    public boolean isReadable(@Nonnull MediaType mediaType) {
        return ServiceJsonpSupport.isMediaTypeSame(SupportedMediaType.SERVICE_PACKAGE_REQUEST_MT, mediaType);
    }
}

