/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.service.core.service.request.io.jsonp;

import com.covisint.core.http.service.core.AbstractRealmScopedResource;
import com.covisint.core.http.service.core.ResourceReference;
import com.covisint.core.http.service.core.io.jsonp.AbstractRealmScopedResourceWriter;
import com.covisint.core.http.service.core.io.jsonp.JsonpSupport;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.platform.service.core.service.ServiceJsonpSupport;
import com.covisint.platform.service.core.service.SupportedMediaType;
import com.covisint.platform.service.core.service.request.ServicePackageRequest;
import com.google.common.net.MediaType;
import javax.json.JsonObjectBuilder;

public class ServicePackageRequestWriter
extends AbstractRealmScopedResourceWriter<ServicePackageRequest> {
    @Nonnull
    protected JsonObjectBuilder writeResource(@Nonnull MediaType mediaType, @Nonnull ServicePackageRequest request) {
        JsonObjectBuilder root = super.writeResource(mediaType, (AbstractRealmScopedResource)request);
        this.writeResourceReference("requestor", new ResourceReference(request.getRequestor().getId(), request.getRequestor().getType()), root);
        this.writeResourceReference("servicePackage", new ResourceReference(request.getRequestedPackage().getId(), "servicePackage"), root);
        if (request.getParentRequest() != null) {
            this.writeResourceReference("prerequisite", new ResourceReference(request.getParentRequest().getId(), request.getParentRequest().getType()), root);
        }
        JsonpSupport.addPropertyIfNonnullValue((JsonObjectBuilder)root, (String)"reason", (String)request.getReason());
        return root;
    }

    @Nonnull
    public Class<ServicePackageRequest> getResourceType() {
        return ServicePackageRequest.class;
    }

    public boolean isWritable(@Nonnull Class klass, @Nonnull MediaType mediaType) {
        return ServiceJsonpSupport.isMediaTypeSame(SupportedMediaType.SERVICE_PACKAGE_REQUEST_MT, mediaType);
    }
}

