/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.core.trace.servlet;

import com.covisint.core.support.aspect.NonnullValidator;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.primitive.StringSupport;
import com.covisint.core.trace.Span;
import com.covisint.core.trace.SpanHolder;
import java.io.IOException;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public final class SpanFilter
implements Filter {
    private static Logger log;
    private AtomicLong traceIdGenerator;
    private AtomicLong spanIdGenerator;
    private String traceIdHeaderName = "X-Trace";
    private String spanIdHeaderName = "X-Span";
    private String spanName;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        SpanFilter.ajc$preClinit();
        log = LoggerFactory.getLogger(SpanFilter.class);
    }

    private Span extractSpan(@Nonnull HttpServletRequest request) {
        HttpServletRequest httpServletRequest = request;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)httpServletRequest);
        NonnullValidator.aspectOf().validateMethodArg1((Object)httpServletRequest, joinPoint);
        long parentSpanId = 0L;
        long traceId = this.traceIdGenerator.getAndIncrement();
        long spanId = this.spanIdGenerator.getAndIncrement();
        String traceIdStr = request.getHeader(this.traceIdHeaderName);
        String parentSpanIdStr = request.getHeader(this.spanIdHeaderName);
        if (traceIdStr != null) {
            try {
                traceId = Long.valueOf(traceIdStr);
            }
            catch (NumberFormatException numberFormatException) {
                log.warn("Could not parse trace id header value {}. Expected a java.lang.Long", (Object)traceId);
            }
        }
        if (parentSpanIdStr != null) {
            try {
                parentSpanId = Long.valueOf(parentSpanIdStr);
            }
            catch (NumberFormatException numberFormatException) {
                log.warn("Could not parse span id header value {}. Expected a java.lang.Long", (Object)spanId);
            }
        }
        return SpanHolder.createSpan(traceId, spanId, parentSpanId, this.spanName, System.currentTimeMillis());
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            if (request instanceof HttpServletRequest) {
                Span span = this.extractSpan((HttpServletRequest)request);
                MDC.put((String)"traceId", (String)String.valueOf(span.getTraceId()));
                MDC.put((String)"parentSpanId", (String)String.valueOf(span.getParentSpanId()));
                MDC.put((String)"spanId", (String)String.valueOf(span.getSpanId()));
                log.debug("Extracted span and bound to thread and MDC: {}", (Object)span);
            }
            chain.doFilter(request, response);
        }
        finally {
            MDC.clear();
            Span removedSpan = SpanHolder.clearCurrentSpan();
            log.debug("Cleared span from thread local context: {}", (Object)removedSpan);
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        Random random = new Random(System.currentTimeMillis());
        this.traceIdGenerator = new AtomicLong(Math.abs(random.nextLong()));
        this.spanIdGenerator = new AtomicLong(Math.abs(random.nextLong()));
        this.spanName = filterConfig.getInitParameter("spanName");
        if (StringSupport.trimOrNull((String)this.spanName) == null) {
            this.spanName = Thread.currentThread().getName();
        }
        log.debug("Using span name: {}", (Object)this.spanName);
        String overridingTraceIdHeader = filterConfig.getInitParameter("traceIdHeaderName");
        String overridingSpanIdHeader = filterConfig.getInitParameter("spanIdHeaderName");
        if (StringSupport.trimOrNull((String)overridingTraceIdHeader) != null) {
            log.debug("Using different trace id header: {}", (Object)overridingTraceIdHeader);
            this.traceIdHeaderName = overridingTraceIdHeader;
        }
        if (StringSupport.trimOrNull((String)overridingSpanIdHeader) != null) {
            log.debug("Using different span id header: {}", (Object)overridingSpanIdHeader);
            this.spanIdHeaderName = overridingSpanIdHeader;
        }
    }

    public void destroy() {
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("SpanFilter.java", SpanFilter.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "extractSpan", "com.covisint.core.trace.servlet.SpanFilter", "javax.servlet.http.HttpServletRequest", "request", "", "com.covisint.core.trace.Span"), 54);
    }
}

