/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.oauth.core.util;

import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NotEmpty;
import java.io.ByteArrayInputStream;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.spec.X509EncodedKeySpec;
import org.apache.commons.codec.binary.Base64;

public final class CertificateUtils {
    private static CertificateFactory factory;

    private CertificateUtils() {
    }

    @Nonnull
    public static Certificate parseCertificate(@Nonnull @NotEmpty String cert) throws GeneralSecurityException {
        ByteArrayInputStream stream = new ByteArrayInputStream(cert.getBytes());
        Certificate certificate = factory.generateCertificate(stream);
        return certificate;
    }

    @Nonnull
    public static PublicKey parsePublicKey(@Nonnull String pubkey) throws GeneralSecurityException {
        byte[] encKey = Base64.decodeBase64((byte[])pubkey.getBytes());
        X509EncodedKeySpec pubKeySpec = new X509EncodedKeySpec(encKey);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return keyFactory.generatePublic(pubKeySpec);
    }

    @Nonnull
    public static String serializePublicKey(@Nonnull PublicKey key) {
        return Base64.encodeBase64String((byte[])key.getEncoded());
    }

    @Nonnull
    public static String serializeCertificate(@Nonnull Certificate cert) throws CertificateEncodingException {
        return Base64.encodeBase64String((byte[])cert.getEncoded());
    }

    static {
        try {
            factory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw new RuntimeException("Could not create certificate factory", e);
        }
    }
}

