/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.core.support.httpclient;

import com.covisint.core.support.aspect.NonnullValidator;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.primitive.StringSupport;
import com.google.common.base.Supplier;
import java.io.IOException;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.protocol.HttpContext;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AuthorizationTokenInterceptor
implements HttpRequestInterceptor {
    public static final String HEADER_NAME = "Authorization";
    private static final String BEARER = "Bearer";
    private final Logger log;
    private final Supplier<String> accessTokenSupplier;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    public AuthorizationTokenInterceptor(@Nonnull Supplier<String> tokenSupplier) {
        Supplier<String> supplier = tokenSupplier;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, supplier);
        NonnullValidator.aspectOf().validateConstructorArg1(supplier, joinPoint);
        this.log = LoggerFactory.getLogger(AuthorizationTokenInterceptor.class);
        this.accessTokenSupplier = tokenSupplier;
    }

    public void process(@Nonnull HttpRequest request, @Nonnull HttpContext context) throws HttpException, IOException {
        HttpContext httpContext = context;
        HttpRequest httpRequest = request;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)httpRequest, (Object)httpContext);
        NonnullValidator.aspectOf().validateMethodArg1((Object)httpRequest, joinPoint);
        NonnullValidator.aspectOf().validateMethodArg2((Object)httpContext, joinPoint);
        String accessToken = (String)this.accessTokenSupplier.get();
        if (StringSupport.trimOrNull((String)accessToken) == null) {
            this.log.warn("Access token returned from supplier was null or empty.");
            return;
        }
        request.addHeader(HEADER_NAME, String.format("%s %s", BEARER, accessToken));
    }

    static {
        AuthorizationTokenInterceptor.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AuthorizationTokenInterceptor.java", AuthorizationTokenInterceptor.class);
        ajc$tjp_0 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1", "com.covisint.core.support.httpclient.AuthorizationTokenInterceptor", "com.google.common.base.Supplier", "tokenSupplier", ""), 38);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "process", "com.covisint.core.support.httpclient.AuthorizationTokenInterceptor", "org.apache.http.HttpRequest:org.apache.http.protocol.HttpContext", "request:context", "org.apache.http.HttpException:java.io.IOException", "void"), 43);
    }
}

