/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.service.client.sdk;

import com.covisint.core.http.service.core.ServiceException;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NonnullElements;
import com.covisint.core.support.constraint.NotEmpty;
import com.covisint.core.support.httpclient.HttpClientBuilder;
import com.covisint.platform.oauth.client.token.sdk.AuthConfigurationProvider;
import com.covisint.platform.oauth.client.token.sdk.DefaultAuthConfigurationProvider;
import com.covisint.platform.oauth.client.token.sdk.TokenSupplier;
import com.covisint.platform.service.client.service.ServiceMembershipClientFactory;
import com.covisint.platform.service.client.service.ServiceMembershipClientImpl;
import com.covisint.platform.service.core.service.Service;
import com.google.common.base.Supplier;
import com.google.common.util.concurrent.CheckedFuture;
import java.util.List;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;

public class ServiceMembershipSDK
extends ServiceMembershipClientFactory {
    private AuthConfigurationProvider authConfigProvider;

    public ServiceMembershipSDK(@Nonnull @NotEmpty String serviceUrl) {
        super(serviceUrl);
    }

    @Nonnull
    protected AuthConfigurationProvider getAuthConfigProvider() {
        if (this.authConfigProvider == null) {
            this.authConfigProvider = new DefaultAuthConfigurationProvider();
        }
        return this.authConfigProvider;
    }

    protected HttpClientBuilder populateHttpClientBuilder(@Nonnull HttpClientBuilder builder) {
        TokenSupplier tokenSupplier = new TokenSupplier(this.getAuthConfigProvider());
        builder.addAuthorizationTokenInterceptor((Supplier)tokenSupplier);
        return builder;
    }

    public ServiceMembershipSDK setAuthConfigProvider(@Nonnull AuthConfigurationProvider provider) {
        this.authConfigProvider = provider;
        return this;
    }

    public ServiceMembershipClientImpl create() {
        throw new UnsupportedOperationException("Please use #newClient to create new client instances.");
    }

    @Nonnull
    public ServiceMembershipClient newClient() {
        return new ClientImpl((ServiceMembershipClientImpl)super.create());
    }

    private static final class ClientImpl
    implements ServiceMembershipClient {
        private final ServiceMembershipClientImpl delegate;

        private ClientImpl(@Nonnull ServiceMembershipClientImpl newDelegate) {
            this.delegate = newDelegate;
        }

        @Override
        @Nonnull
        public CheckedFuture<Iterable<Service>, ServiceException> listMemberServices(@Nonnull @NotEmpty String packageId) {
            return this.delegate.getMemberServices(packageId, (HttpContext)new BasicHttpContext());
        }

        @Override
        @Nonnull
        public CheckedFuture<Void, ServiceException> assignServiceMemberships(@Nonnull String packageId, @Nonnull @NonnullElements List<String> serviceIds) {
            return this.delegate.assignServiceMemberships(packageId, serviceIds, (HttpContext)new BasicHttpContext());
        }

        @Override
        @Nonnull
        public CheckedFuture<Void, ServiceException> removeServiceMemberships(@Nonnull String packageId, @Nonnull @NonnullElements List<String> serviceIds) {
            return this.delegate.removeServiceMemberships(packageId, serviceIds, (HttpContext)new BasicHttpContext());
        }
    }

    public static interface ServiceMembershipClient {
        @Nonnull
        public CheckedFuture<Iterable<Service>, ServiceException> listMemberServices(@Nonnull @NotEmpty String var1);

        @Nonnull
        public CheckedFuture<Void, ServiceException> assignServiceMemberships(@Nonnull String var1, @Nonnull @NonnullElements List<String> var2);

        @Nonnull
        public CheckedFuture<Void, ServiceException> removeServiceMemberships(@Nonnull String var1, @Nonnull @NonnullElements List<String> var2);
    }
}

