/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.service.client.sdk;

import com.covisint.core.http.service.core.Page;
import com.covisint.core.http.service.core.ServiceException;
import com.covisint.core.http.service.core.SortCriteria;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NotEmpty;
import com.covisint.core.support.httpclient.HttpClientBuilder;
import com.covisint.platform.oauth.client.token.sdk.AuthConfigurationProvider;
import com.covisint.platform.oauth.client.token.sdk.DefaultAuthConfigurationProvider;
import com.covisint.platform.oauth.client.token.sdk.TokenSupplier;
import com.covisint.platform.service.client.service.grant.ServicePackageGrantClientFactory;
import com.covisint.platform.service.client.service.grant.ServicePackageGrantClientImpl;
import com.covisint.platform.service.core.service.grant.ServicePackageGrant;
import com.google.common.base.Supplier;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.CheckedFuture;
import java.util.List;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;

public class ServicePackageGrantSDK
extends ServicePackageGrantClientFactory {
    private AuthConfigurationProvider authConfigProvider;

    public ServicePackageGrantSDK(@Nonnull @NotEmpty String serviceUrl) {
        super(serviceUrl);
    }

    @Nonnull
    protected AuthConfigurationProvider getAuthConfigProvider() {
        if (this.authConfigProvider == null) {
            this.authConfigProvider = new DefaultAuthConfigurationProvider();
        }
        return this.authConfigProvider;
    }

    protected HttpClientBuilder populateHttpClientBuilder(@Nonnull HttpClientBuilder builder) {
        TokenSupplier tokenSupplier = new TokenSupplier(this.getAuthConfigProvider());
        builder.addAuthorizationTokenInterceptor((Supplier)tokenSupplier);
        return builder;
    }

    public ServicePackageGrantSDK setAuthConfigProvider(@Nonnull AuthConfigurationProvider provider) {
        this.authConfigProvider = provider;
        return this;
    }

    public ServicePackageGrantClientImpl create() {
        throw new UnsupportedOperationException("Please use #newClient to create new client instances.");
    }

    @Nonnull
    public ServicePackageGrantClient newClient() {
        return new ClientImpl((ServicePackageGrantClientImpl)super.create());
    }

    private static final class ClientImpl
    implements ServicePackageGrantClient {
        private final ServicePackageGrantClientImpl delegate;

        private ClientImpl(@Nonnull ServicePackageGrantClientImpl newDelegate) {
            this.delegate = newDelegate;
        }

        @Override
        @Nonnull
        public CheckedFuture<Iterable<ServicePackageGrant>, ServiceException> listPersonGrants(@Nonnull @NotEmpty String personId, @Nonnull Page page) {
            return this.delegate.searchPersonGrants(personId, (HttpContext)new BasicHttpContext(), page);
        }

        @Override
        @Nonnull
        public CheckedFuture<Iterable<ServicePackageGrant>, ServiceException> listOrganizationGrants(@Nonnull @NotEmpty String organizationId, @Nonnull Page page) {
            return this.delegate.searchOrganizationGrants(organizationId, (HttpContext)new BasicHttpContext(), page);
        }

        @Override
        @Nonnull
        public CheckedFuture<ServicePackageGrant, ServiceException> getPersonGrant(@Nonnull @NotEmpty String personId, @Nonnull @NotEmpty String packageId) {
            return this.delegate.getPersonGrant(personId, packageId, (HttpContext)new BasicHttpContext());
        }

        @Override
        @Nonnull
        public CheckedFuture<ServicePackageGrant, ServiceException> getOrganizationGrant(@Nonnull @NotEmpty String organizationId, String packageId) {
            return this.delegate.getOrganizationGrant(organizationId, packageId, (HttpContext)new BasicHttpContext());
        }

        @Override
        @Nonnull
        public CheckedFuture<ServicePackageGrant, ServiceException> assignPersonGrant(@Nonnull @NotEmpty String personId, @Nonnull @NotEmpty String packageId) {
            return this.delegate.assignPersonGrant(personId, packageId, (HttpContext)new BasicHttpContext());
        }

        @Override
        @Nonnull
        public CheckedFuture<ServicePackageGrant, ServiceException> assignOrganizationGrant(@Nonnull @NotEmpty String organizationId, @Nonnull @NotEmpty String packageId) {
            return this.delegate.assignOrganizationGrant(organizationId, packageId, (HttpContext)new BasicHttpContext());
        }

        @Override
        @Nonnull
        public CheckedFuture<List<ServicePackageGrant>, ServiceException> search(String grantedPackageId, ServicePackageGrantClient.GranteeType granteeType, @Nonnull Page page) {
            ArrayListMultimap searchCriteria = ArrayListMultimap.create();
            searchCriteria.put((Object)"grantedPackageId", (Object)grantedPackageId);
            if (granteeType != null) {
                searchCriteria.put((Object)"granteeType", (Object)granteeType.toString());
            }
            return this.delegate.search((Multimap<String, String>)searchCriteria, SortCriteria.NONE, page, (HttpContext)new BasicHttpContext());
        }
    }

    public static interface ServicePackageGrantClient {
        @Nonnull
        public CheckedFuture<Iterable<ServicePackageGrant>, ServiceException> listPersonGrants(@Nonnull @NotEmpty String var1, @Nonnull Page var2);

        @Nonnull
        public CheckedFuture<Iterable<ServicePackageGrant>, ServiceException> listOrganizationGrants(@Nonnull @NotEmpty String var1, @Nonnull Page var2);

        @Nonnull
        public CheckedFuture<ServicePackageGrant, ServiceException> getPersonGrant(@Nonnull @NotEmpty String var1, @Nonnull @NotEmpty String var2);

        @Nonnull
        public CheckedFuture<ServicePackageGrant, ServiceException> getOrganizationGrant(@Nonnull @NotEmpty String var1, @Nonnull @NotEmpty String var2);

        @Nonnull
        public CheckedFuture<ServicePackageGrant, ServiceException> assignPersonGrant(@Nonnull @NotEmpty String var1, @Nonnull @NotEmpty String var2);

        @Nonnull
        public CheckedFuture<ServicePackageGrant, ServiceException> assignOrganizationGrant(@Nonnull @NotEmpty String var1, @Nonnull @NotEmpty String var2);

        @Nonnull
        public CheckedFuture<List<ServicePackageGrant>, ServiceException> search(@Nonnull @NotEmpty String var1, @Nonnull @NotEmpty GranteeType var2, @Nonnull Page var3);

        public static enum GranteeType {
            PERSON("person"),
            ORGANIZATION("organization");

            private final String id;

            private GranteeType(String newId) {
                this.id = newId;
            }

            public String toString() {
                return this.id;
            }
        }
    }
}

