/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.service.client.service;

import com.covisint.core.http.service.client.BaseResourceClient;
import com.covisint.core.http.service.client.CachingFutureCallback;
import com.covisint.core.http.service.client.ClientException;
import com.covisint.core.http.service.core.Page;
import com.covisint.core.http.service.core.Resource;
import com.covisint.core.http.service.core.ServiceException;
import com.covisint.core.http.service.core.SortCriteria;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NonnullElements;
import com.covisint.core.support.constraint.NotEmpty;
import com.covisint.platform.service.client.service.ServiceMembershipClient;
import com.covisint.platform.service.core.service.Service;
import com.covisint.platform.service.core.service.SupportedMediaType;
import com.damnhandy.uri.template.MalformedUriTemplateException;
import com.damnhandy.uri.template.UriTemplate;
import com.damnhandy.uri.template.VariableExpansionException;
import com.google.common.collect.Multimap;
import com.google.common.net.MediaType;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceMembershipClientImpl
extends BaseResourceClient<Resource>
implements ServiceMembershipClient {
    private final Logger log = LoggerFactory.getLogger(ServiceMembershipClientImpl.class);
    private UriTemplate retrieveMemberServicesUriTemplate;
    private UriTemplate assignServiceMembershipUriTemplate;
    private UriTemplate removeServiceMembershipUriTemplate;

    private void buildEndpointWithQueryParams(@Nonnull StringBuilder endpointWithQueryParams) {
        endpointWithQueryParams.append("{?");
        endpointWithQueryParams.append("packageId*,");
        endpointWithQueryParams.append("serviceId*,");
        endpointWithQueryParams.append("}");
    }

    private void populateQueryParamValues(@Nonnull String packageId, @Nonnull List<String> serviceIds, UriTemplate searchEndPointTemplate) {
        searchEndPointTemplate.set("packageId", (Object)packageId);
        searchEndPointTemplate.set("serviceId", serviceIds);
    }

    void setRetrieveMemberServicesUriTemplate(@Nonnull UriTemplate template) {
        this.retrieveMemberServicesUriTemplate = template;
    }

    void setAssignServiceMembershipUriTemplate(@Nonnull UriTemplate template) {
        this.assignServiceMembershipUriTemplate = template;
    }

    void setRemoveServiceMembershipUriTemplate(@Nonnull UriTemplate template) {
        this.removeServiceMembershipUriTemplate = template;
    }

    protected String getEndpointWithQueryParams(@Nonnull String packageId, @Nonnull List<String> serviceIds, @Nonnull UriTemplate template) throws MalformedUriTemplateException, VariableExpansionException {
        StringBuilder endpointWithQueryParams = new StringBuilder(template.expand());
        this.buildEndpointWithQueryParams(endpointWithQueryParams);
        UriTemplate endpointTemplate = UriTemplate.fromTemplate((String)endpointWithQueryParams.toString());
        this.populateQueryParamValues(packageId, serviceIds, endpointTemplate);
        return endpointTemplate.expand();
    }

    @Override
    @Nonnull
    public CheckedFuture<Iterable<Service>, ServiceException> getMemberServices(@Nonnull @NotEmpty String packageId, @Nonnull HttpContext httpContext) {
        MediaType resourceMediaType = MediaType.parse((String)SupportedMediaType.SERVICE_MT.value());
        String cacheKey = String.format("get-by-id-%s", packageId);
        Iterable cachedResult = (Iterable)this.getLocalCache().getIfPresent((Object)cacheKey);
        if (cachedResult != null) {
            this.log.debug("Found active cache for key {}; using it.", (Object)cacheKey);
            return Futures.immediateCheckedFuture((Object)cachedResult);
        }
        try {
            CheckedFuture futureResult = this.execute((HttpUriRequest)new HttpGet(this.retrieveMemberServicesUriTemplate.set("packageId", (Object)packageId).expand()), resourceMediaType, httpContext);
            Futures.addCallback((ListenableFuture)futureResult, (FutureCallback)new CachingFutureCallback(this.getLocalCache(), cacheKey));
            return futureResult;
        }
        catch (VariableExpansionException e) {
            this.log.error("Error occurred while expanding URL template.", (Throwable)e);
            throw new ClientException("Error occurred while expanding URL template.");
        }
    }

    @Override
    @Nonnull
    public CheckedFuture<Void, ServiceException> assignServiceMemberships(@Nonnull String packageId, @Nonnull @NonnullElements List<String> serviceIds, @Nonnull HttpContext httpContext) {
        MediaType resourceMediaType = MediaType.parse((String)SupportedMediaType.SERVICE_MT.value());
        try {
            return this.execute((HttpUriRequest)new HttpPost(this.getEndpointWithQueryParams(packageId, serviceIds, this.assignServiceMembershipUriTemplate)), resourceMediaType, httpContext);
        }
        catch (MalformedUriTemplateException | VariableExpansionException e) {
            this.log.error("Error occurred while expanding URL template.", e);
            throw new ClientException("Error occurred while expanding URL template.");
        }
    }

    @Override
    @Nonnull
    public CheckedFuture<Void, ServiceException> removeServiceMemberships(@Nonnull String packageId, @Nonnull @NonnullElements List<String> serviceIds, @Nonnull HttpContext httpContext) {
        MediaType resourceMediaType = MediaType.parse((String)SupportedMediaType.SERVICE_MT.value());
        try {
            return this.execute((HttpUriRequest)new HttpPost(this.getEndpointWithQueryParams(packageId, serviceIds, this.removeServiceMembershipUriTemplate)), resourceMediaType, httpContext);
        }
        catch (MalformedUriTemplateException | VariableExpansionException e) {
            this.log.error("Error occurred while expanding URL template.", e);
            throw new ClientException("Error occurred while expanding URL template.");
        }
    }

    public CheckedFuture<Resource, ServiceException> add(Resource resource, HttpContext httpContext) {
        throw new UnsupportedOperationException();
    }

    public CheckedFuture<Resource, ServiceException> delete(String id, HttpContext httpContext) {
        throw new UnsupportedOperationException();
    }

    public CheckedFuture<Resource, ServiceException> get(Resource resource, HttpContext httpContext) {
        throw new UnsupportedOperationException();
    }

    public CheckedFuture<Resource, ServiceException> get(String id, HttpContext httpContext) {
        throw new UnsupportedOperationException();
    }

    public CheckedFuture<Resource, ServiceException> persist(Resource resource, HttpContext httpContext) {
        throw new UnsupportedOperationException();
    }

    public CheckedFuture<List<Resource>, ServiceException> search(Multimap<String, String> searchCriteria, SortCriteria sortCriteria, Page page, HttpContext httpContext) {
        throw new UnsupportedOperationException();
    }

    public CheckedFuture<List<Resource>, ServiceException> search(Multimap<String, String> searchCriteria, SortCriteria sortCriteria, Page page, HttpContext httpContext, MediaType mediaType, String searchResourcesEndPoint) {
        throw new UnsupportedOperationException();
    }
}

