/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.service.client.service.grant;

import com.covisint.core.http.service.client.BaseResourceClient;
import com.covisint.core.http.service.client.CachingFutureCallback;
import com.covisint.core.http.service.client.ClientException;
import com.covisint.core.http.service.core.Page;
import com.covisint.core.http.service.core.ResourceReference;
import com.covisint.core.http.service.core.ServiceException;
import com.covisint.core.http.service.core.SortCriteria;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NotEmpty;
import com.covisint.platform.service.client.service.grant.ServicePackageGrantClient;
import com.covisint.platform.service.core.service.SupportedMediaType;
import com.covisint.platform.service.core.service.grant.ServicePackageGrant;
import com.damnhandy.uri.template.UriTemplate;
import com.damnhandy.uri.template.VariableExpansionException;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.net.MediaType;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServicePackageGrantClientImpl
extends BaseResourceClient<ServicePackageGrant>
implements ServicePackageGrantClient {
    static final MediaType SERVICE_PACKAGE_GRANT_MT = MediaType.parse((String)SupportedMediaType.SERVICE_PACKAGE_GRANT_MT.value());
    static final String GRANTEE_TYPE_PERSON = "person";
    static final String GRANTEE_TYPE_ORGANIZATION = "organization";
    static final String SERVICE_PACKAGE_TYPE = "servicePackage";
    private final Logger log = LoggerFactory.getLogger(ServicePackageGrantClientImpl.class);
    private UriTemplate personPackageGrantsCollectionUriTemplate;
    private UriTemplate organizationPackageGrantsCollectionUriTemplate;
    private UriTemplate personPackageGrantUriTemplate;
    private UriTemplate organizationPackageGrantUriTemplate;
    private UriTemplate packageGrantCollectionUriTemplate;

    private CheckedFuture<Iterable<ServicePackageGrant>, ServiceException> searchServicePackageGrants(@Nonnull Multimap<String, String> searchCriteria, @Nonnull SortCriteria sortCriteria, @Nonnull Page page, HttpContext httpContext, MediaType mediaType, String searchResourcesEndPoint) {
        String cacheKey = ServicePackageGrantClientImpl.buildSearchKey(searchCriteria, (SortCriteria)sortCriteria, (Page)page);
        Iterable cachedResult = (Iterable)this.getLocalCache().getIfPresent((Object)cacheKey);
        if (cachedResult != null) {
            this.log.debug("Found active cache for key {}; using it.", (Object)cacheKey);
            return Futures.immediateCheckedFuture((Object)cachedResult);
        }
        String endpointWithQueryParams = this.getEndpointWithQueryParams(searchCriteria, sortCriteria, page, searchResourcesEndPoint);
        CheckedFuture futureResult = this.execute((HttpUriRequest)new HttpGet(endpointWithQueryParams), mediaType, httpContext);
        Futures.addCallback((ListenableFuture)futureResult, (FutureCallback)new CachingFutureCallback(this.getLocalCache(), cacheKey));
        return futureResult;
    }

    void setOrganizationPackageGrantsCollectionUriTemplate(@Nonnull UriTemplate template) {
        this.organizationPackageGrantsCollectionUriTemplate = template;
    }

    void setPersonPackageGrantsCollectionUriTemplate(@Nonnull UriTemplate template) {
        this.personPackageGrantsCollectionUriTemplate = template;
    }

    void setOrganizationPackageGrantUriTemplate(@Nonnull UriTemplate template) {
        this.organizationPackageGrantUriTemplate = template;
    }

    void setPersonPackageGrantUriTemplate(@Nonnull UriTemplate template) {
        this.personPackageGrantUriTemplate = template;
    }

    public void setPackageGrantCollectionUriTemplate(UriTemplate template) {
        this.packageGrantCollectionUriTemplate = template;
    }

    @Override
    @Nonnull
    public CheckedFuture<Iterable<ServicePackageGrant>, ServiceException> searchPersonGrants(@Nonnull @NotEmpty String personId, @Nonnull HttpContext httpContext, @Nonnull Page page) {
        try {
            String url = this.personPackageGrantsCollectionUriTemplate.set("personId", (Object)personId).expand();
            ArrayListMultimap searchCriteria = ArrayListMultimap.create();
            return this.searchServicePackageGrants((Multimap<String, String>)searchCriteria, SortCriteria.NONE, page, httpContext, SERVICE_PACKAGE_GRANT_MT, url);
        }
        catch (VariableExpansionException e) {
            this.log.error("Error occurred while expanding URL template.", (Throwable)e);
            throw new ClientException("Error occurred while expanding URL template.");
        }
    }

    @Override
    @Nonnull
    public CheckedFuture<Iterable<ServicePackageGrant>, ServiceException> searchOrganizationGrants(@Nonnull @NotEmpty String organizationId, @Nonnull HttpContext httpContext, @Nonnull Page page) {
        try {
            String url = this.organizationPackageGrantsCollectionUriTemplate.set("organizationId", (Object)organizationId).expand();
            ArrayListMultimap searchCriteria = ArrayListMultimap.create();
            return this.searchServicePackageGrants((Multimap<String, String>)searchCriteria, SortCriteria.NONE, page, httpContext, SERVICE_PACKAGE_GRANT_MT, url);
        }
        catch (VariableExpansionException e) {
            this.log.error("Error occurred while expanding URL template.", (Throwable)e);
            throw new ClientException("Error occurred while expanding URL template.");
        }
    }

    @Override
    @Nonnull
    public CheckedFuture<ServicePackageGrant, ServiceException> getPersonGrant(@Nonnull @NotEmpty String personId, @Nonnull @NotEmpty String packageId, @Nonnull HttpContext httpContext) {
        String cacheKey = String.format("get-by-id-personId:%s-packageId:%s", personId, packageId);
        ServicePackageGrant cachedResult = (ServicePackageGrant)this.getLocalCache().getIfPresent((Object)cacheKey);
        if (cachedResult != null) {
            this.log.debug("Found active cache for key {}; using it.", (Object)cacheKey);
            return Futures.immediateCheckedFuture((Object)cachedResult);
        }
        try {
            String url = this.personPackageGrantUriTemplate.set("personId", (Object)personId).set("packageId", (Object)packageId).expand();
            CheckedFuture futureResult = this.execute((HttpUriRequest)new HttpGet(url), SERVICE_PACKAGE_GRANT_MT, httpContext);
            Futures.addCallback((ListenableFuture)futureResult, (FutureCallback)new CachingFutureCallback(this.getLocalCache(), cacheKey));
            return futureResult;
        }
        catch (VariableExpansionException e) {
            this.log.error("Error occurred while expanding URL template.", (Throwable)e);
            throw new ClientException("Error occurred while expanding URL template.");
        }
    }

    @Override
    @Nonnull
    public CheckedFuture<ServicePackageGrant, ServiceException> getOrganizationGrant(@Nonnull @NotEmpty String organizationId, @Nonnull @NotEmpty String packageId, @Nonnull HttpContext httpContext) {
        String cacheKey = String.format("get-by-id-organizationId:%s-packageId:%s", organizationId, packageId);
        ServicePackageGrant cachedResult = (ServicePackageGrant)this.getLocalCache().getIfPresent((Object)cacheKey);
        if (cachedResult != null) {
            this.log.debug("Found active cache for key {}; using it.", (Object)cacheKey);
            return Futures.immediateCheckedFuture((Object)cachedResult);
        }
        try {
            String url = this.organizationPackageGrantUriTemplate.set("organizationId", (Object)organizationId).set("packageId", (Object)packageId).expand();
            CheckedFuture futureResult = this.execute((HttpUriRequest)new HttpGet(url), SERVICE_PACKAGE_GRANT_MT, httpContext);
            Futures.addCallback((ListenableFuture)futureResult, (FutureCallback)new CachingFutureCallback(this.getLocalCache(), cacheKey));
            return futureResult;
        }
        catch (VariableExpansionException e) {
            this.log.error("Error occurred while expanding URL template.", (Throwable)e);
            throw new ClientException("Error occurred while expanding URL template.");
        }
    }

    @Override
    @Nonnull
    public CheckedFuture<ServicePackageGrant, ServiceException> assignPersonGrant(@Nonnull @NotEmpty String personId, @Nonnull @NotEmpty String packageId, @Nonnull HttpContext httpContext) {
        try {
            ServicePackageGrant grant = (ServicePackageGrant)new ServicePackageGrant().setGrantee(new ResourceReference(personId, GRANTEE_TYPE_PERSON)).setServicePackage(new ResourceReference(packageId, SERVICE_PACKAGE_TYPE)).setVersion(Long.valueOf(1L));
            String url = this.personPackageGrantUriTemplate.set("personId", (Object)personId).set("packageId", (Object)packageId).expand();
            return this.executeWithBody((HttpEntityEnclosingRequestBase)new HttpPut(url), SERVICE_PACKAGE_GRANT_MT, grant, httpContext);
        }
        catch (VariableExpansionException e) {
            this.log.error("Error occurred while expanding URL template.", (Throwable)e);
            throw new ClientException("Error occurred while expanding URL template.");
        }
    }

    @Override
    @Nonnull
    public CheckedFuture<ServicePackageGrant, ServiceException> assignOrganizationGrant(@Nonnull @NotEmpty String organizationId, @Nonnull @NotEmpty String packageId, @Nonnull HttpContext httpContext) {
        try {
            ServicePackageGrant grant = (ServicePackageGrant)new ServicePackageGrant().setGrantee(new ResourceReference(organizationId, GRANTEE_TYPE_ORGANIZATION)).setServicePackage(new ResourceReference(packageId, SERVICE_PACKAGE_TYPE)).setVersion(Long.valueOf(1L));
            String url = this.organizationPackageGrantUriTemplate.set("organizationId", (Object)organizationId).set("packageId", (Object)packageId).expand();
            return this.executeWithBody((HttpEntityEnclosingRequestBase)new HttpPut(url), SERVICE_PACKAGE_GRANT_MT, grant, httpContext);
        }
        catch (VariableExpansionException e) {
            this.log.error("Error occurred while expanding URL template.", (Throwable)e);
            throw new ClientException("Error occurred while expanding URL template.");
        }
    }

    public CheckedFuture<ServicePackageGrant, ServiceException> add(ServicePackageGrant resource, HttpContext httpContext) {
        throw new UnsupportedOperationException();
    }

    public CheckedFuture<ServicePackageGrant, ServiceException> delete(String id, HttpContext httpContext) {
        throw new UnsupportedOperationException();
    }

    public CheckedFuture<ServicePackageGrant, ServiceException> get(ServicePackageGrant resource, HttpContext httpContext) {
        throw new UnsupportedOperationException();
    }

    public CheckedFuture<ServicePackageGrant, ServiceException> get(String id, HttpContext httpContext) {
        throw new UnsupportedOperationException();
    }

    public CheckedFuture<ServicePackageGrant, ServiceException> persist(ServicePackageGrant resource, HttpContext httpContext) {
        throw new UnsupportedOperationException();
    }

    public CheckedFuture<List<ServicePackageGrant>, ServiceException> search(Multimap<String, String> searchCriteria, SortCriteria sortCriteria, Page page, HttpContext httpContext) {
        String url = null;
        try {
            url = this.packageGrantCollectionUriTemplate.expand();
        }
        catch (VariableExpansionException e) {
            this.log.error("Error occurred while expanding URL template.", (Throwable)e);
            throw new ClientException("Error occurred while expanding URL template.");
        }
        return this.search(searchCriteria, sortCriteria, page, httpContext, SERVICE_PACKAGE_GRANT_MT, url);
    }

    public CheckedFuture<List<ServicePackageGrant>, ServiceException> search(Multimap<String, String> searchCriteria, SortCriteria sortCriteria, Page page, HttpContext httpContext, MediaType mediaType, String searchResourcesEndPoint) {
        return super.search(searchCriteria, sortCriteria, page, httpContext, mediaType, searchResourcesEndPoint);
    }
}

