/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.oauth.client.granttype.clientsecret;

import com.covisint.core.http.service.client.BaseResourceClientBuilder;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NotEmpty;
import com.covisint.platform.oauth.client.granttype.clientsecret.ClientSecretGrantTypeClientImpl;
import com.covisint.platform.oauth.core.SupportedMediaType;
import com.damnhandy.uri.template.MalformedUriTemplateException;
import com.damnhandy.uri.template.UriTemplate;
import com.damnhandy.uri.template.UriTemplateBuilder;
import com.damnhandy.uri.template.impl.VarSpec;
import com.google.common.net.MediaType;

public class ClientSecretGrantTypeClientBuilder
extends BaseResourceClientBuilder<ClientSecretGrantTypeClientBuilder, ClientSecretGrantTypeClientImpl> {
    private static final String RESOURCE_COLLECTION_PATH = "/";
    private static final MediaType MEDIA_TYPE = MediaType.parse((String)SupportedMediaType.CLIENT_SECRET_GRANT_MT.value());

    @Nonnull
    @NotEmpty
    protected String getResourceCollectionPath() {
        return RESOURCE_COLLECTION_PATH;
    }

    @Nonnull
    protected MediaType getResourceRepresentation() {
        return MEDIA_TYPE;
    }

    @Nonnull
    protected final UriTemplate getClientSecretGrantTypeByIdEndpoint() {
        try {
            return UriTemplate.buildFromTemplate((String)this.getServiceBaseUrl()).literal("/subjects").path(new VarSpec[]{UriTemplateBuilder.var((String)"subjectId")}).literal("/grants").path(new VarSpec[]{UriTemplateBuilder.var((String)"grantTypeId")}).build();
        }
        catch (MalformedUriTemplateException e) {
            throw new IllegalStateException("Error creating retrieval endpoint template", e);
        }
    }

    @Nonnull
    protected final UriTemplate getClientSecretGrantTypeEndpoint() {
        try {
            return UriTemplate.buildFromTemplate((String)this.getServiceBaseUrl()).literal("/subjects").path(new VarSpec[]{UriTemplateBuilder.var((String)"subjectId")}).literal("/grants").build();
        }
        catch (MalformedUriTemplateException e) {
            throw new IllegalStateException("Error creating search endpoint template", e);
        }
    }

    @Nonnull
    protected final UriTemplate getClientSecretGrantTypeAddEndpoint() {
        try {
            return UriTemplate.buildFromTemplate((String)this.getServiceBaseUrl()).literal("/subjects").path(new VarSpec[]{UriTemplateBuilder.var((String)"subjectId")}).literal("/grants").build();
        }
        catch (MalformedUriTemplateException e) {
            throw new IllegalStateException("Error creating add endpoint template", e);
        }
    }

    @Nonnull
    protected final UriTemplate getClientSecretGrantTypeDeleteEndpoint() {
        try {
            return UriTemplate.buildFromTemplate((String)this.getServiceBaseUrl()).literal("/subjects").path(new VarSpec[]{UriTemplateBuilder.var((String)"subjectId")}).literal("/grants").path(new VarSpec[]{UriTemplateBuilder.var((String)"grantTypeId")}).build();
        }
        catch (MalformedUriTemplateException e) {
            throw new IllegalStateException("Error creating modification endpoint template", e);
        }
    }

    @Nonnull
    public ClientSecretGrantTypeClientImpl build() {
        ClientSecretGrantTypeClientImpl impl = (ClientSecretGrantTypeClientImpl)this.populateBaseBuilder(new ClientSecretGrantTypeClientImpl());
        impl.setGetClientSecretGrantTypeUriTemplate(this.getClientSecretGrantTypeByIdEndpoint());
        impl.setSearchClientSecretGrantTypeUriTemplate(this.getClientSecretGrantTypeEndpoint());
        impl.setPostClientSecretGrantTypeUriTemplate(this.getClientSecretGrantTypeAddEndpoint());
        impl.setDeleteClientSecretGrantTypeUriTemplate(this.getClientSecretGrantTypeDeleteEndpoint());
        return impl;
    }
}

