/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.oauth.client.granttype.certificate;

import com.covisint.core.http.service.client.BaseResourceClient;
import com.covisint.core.http.service.client.CachingFutureCallback;
import com.covisint.core.http.service.client.ClientException;
import com.covisint.core.http.service.core.Page;
import com.covisint.core.http.service.core.ServiceException;
import com.covisint.core.http.service.core.SortCriteria;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NotEmpty;
import com.covisint.platform.oauth.client.granttype.certificate.CertificateGrantTypeClient;
import com.covisint.platform.oauth.client.granttype.clientsecret.ClientSecretGrantTypeClientImpl;
import com.covisint.platform.oauth.core.SupportedMediaType;
import com.covisint.platform.oauth.core.domain.CertificateGrantType;
import com.damnhandy.uri.template.UriTemplate;
import com.damnhandy.uri.template.VariableExpansionException;
import com.google.common.collect.Multimap;
import com.google.common.net.MediaType;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateGrantTypeClientImpl
extends BaseResourceClient<CertificateGrantType>
implements CertificateGrantTypeClient {
    private static final MediaType CERTIFICATE_GRANT_V1_MEDIA_TYPE = MediaType.parse((String)SupportedMediaType.CERTIFICATE_GRANT_MT.value());
    private final Logger log = LoggerFactory.getLogger(ClientSecretGrantTypeClientImpl.class);
    private UriTemplate getCertificateGrantTypeUriTemplate;
    private UriTemplate searchCertificateGrantTypeUriTemplate;
    private UriTemplate postCertificateGrantTypeUriTemplate;
    private UriTemplate deleteCertificateGrantTypeUriTemplate;

    @Nonnull
    private HttpGet getHttpGet(@Nonnull @NotEmpty String url, @Nonnull HttpContext httpContext) {
        HttpGet get = new HttpGet(url);
        String authorization = (String)httpContext.getAttribute("Authorization");
        if (authorization != null) {
            get.setHeader("Authorization", authorization);
        }
        get.setHeader("type", "certificate");
        return get;
    }

    void setGetCertificateGrantTypeUriTemplate(@Nonnull UriTemplate template) {
        this.getCertificateGrantTypeUriTemplate = template;
    }

    void setSearchCertificateGrantTypeUriTemplate(@Nonnull UriTemplate template) {
        this.searchCertificateGrantTypeUriTemplate = template;
    }

    void setPostCertificateGrantTypeUriTemplate(@Nonnull UriTemplate template) {
        this.postCertificateGrantTypeUriTemplate = template;
    }

    void setDeleteCertificateGrantTypeUriTemplate(@Nonnull UriTemplate template) {
        this.deleteCertificateGrantTypeUriTemplate = template;
    }

    @Override
    @Nonnull
    public CheckedFuture<CertificateGrantType, ServiceException> get(@Nonnull @NotEmpty String subjectId, @Nonnull @NotEmpty String grantTypeId, @Nonnull HttpContext httpContext) {
        String cacheKey = String.format("get-by-id-subjectId:%s-grantTypeId:%s", subjectId, grantTypeId);
        CertificateGrantType cachedResult = (CertificateGrantType)this.getLocalCache().getIfPresent((Object)cacheKey);
        if (cachedResult != null) {
            this.log.debug("Found active cache for key {}; using it.", (Object)cacheKey);
            return Futures.immediateCheckedFuture((Object)cachedResult);
        }
        try {
            String url = this.getCertificateGrantTypeUriTemplate.set("subjectId", (Object)subjectId).set("grantTypeId", (Object)grantTypeId).expand();
            CheckedFuture futureResult = this.execute((HttpUriRequest)new HttpGet(url), CERTIFICATE_GRANT_V1_MEDIA_TYPE, httpContext);
            Futures.addCallback((ListenableFuture)futureResult, (FutureCallback)new CachingFutureCallback(this.getLocalCache(), cacheKey));
            return futureResult;
        }
        catch (VariableExpansionException e) {
            this.log.error("Error occurred while expanding URL template.", (Throwable)e);
            throw new ClientException("Error occurred while expanding URL template.");
        }
    }

    @Override
    @Nonnull
    public CheckedFuture<List<CertificateGrantType>, ServiceException> search(@Nonnull @NotEmpty String subjectId, @Nonnull Multimap<String, String> searchCriteria, @Nonnull SortCriteria sortCriteria, @Nonnull Page page, @Nonnull HttpContext context) {
        String cacheKey = CertificateGrantTypeClientImpl.buildSearchKey(searchCriteria, (SortCriteria)sortCriteria, (Page)page);
        List cachedResult = (List)this.getLocalCache().getIfPresent((Object)cacheKey);
        if (cachedResult != null) {
            this.log.debug("Found active cache for key {}; using it.", (Object)cacheKey);
            return Futures.immediateCheckedFuture((Object)cachedResult);
        }
        try {
            String url = this.searchCertificateGrantTypeUriTemplate.set("subjectId", (Object)subjectId).expand();
            CheckedFuture futureResult = this.execute((HttpUriRequest)this.getHttpGet(this.getEndpointWithQueryParams(searchCriteria, sortCriteria, page, url), context), CERTIFICATE_GRANT_V1_MEDIA_TYPE, context);
            Futures.addCallback((ListenableFuture)futureResult, (FutureCallback)new CachingFutureCallback(this.getLocalCache(), cacheKey));
            return futureResult;
        }
        catch (VariableExpansionException e) {
            this.log.error("Error occurred while expanding URL template.", (Throwable)e);
            throw new ClientException("Error occurred while expanding URL template.");
        }
    }

    @Override
    @Nonnull
    public CheckedFuture<CertificateGrantType, ServiceException> add(@Nonnull @NotEmpty String subjectId, @Nonnull CertificateGrantType certificateGrantType, @Nonnull HttpContext httpContext) {
        try {
            String url = this.postCertificateGrantTypeUriTemplate.set("subjectId", (Object)subjectId).expand();
            return this.executeWithBody((HttpEntityEnclosingRequestBase)new HttpPost(url), CERTIFICATE_GRANT_V1_MEDIA_TYPE, certificateGrantType, httpContext);
        }
        catch (VariableExpansionException e) {
            this.log.error("Error occurred while expanding URL template.", (Throwable)e);
            throw new ClientException("Error occurred while expanding URL template.");
        }
    }

    @Override
    @Nonnull
    public CheckedFuture<CertificateGrantType, ServiceException> delete(@Nonnull @NotEmpty String subjectId, @Nonnull @NotEmpty String grantTypeId, @Nonnull HttpContext httpContext) {
        try {
            String url = this.deleteCertificateGrantTypeUriTemplate.set("subjectId", (Object)subjectId).set("grantTypeId", (Object)grantTypeId).expand();
            return this.execute((HttpUriRequest)new HttpDelete(url), CERTIFICATE_GRANT_V1_MEDIA_TYPE, httpContext);
        }
        catch (VariableExpansionException e) {
            this.log.error("Error occurred while expanding URL template.", (Throwable)e);
            throw new ClientException("Error occurred while expanding URL template.");
        }
    }

    public CheckedFuture<CertificateGrantType, ServiceException> add(CertificateGrantType resource, HttpContext httpContext) {
        throw new UnsupportedOperationException();
    }

    public CheckedFuture<CertificateGrantType, ServiceException> delete(String id, HttpContext httpContext) {
        throw new UnsupportedOperationException();
    }

    public CheckedFuture<CertificateGrantType, ServiceException> get(CertificateGrantType resource, HttpContext httpContext) {
        throw new UnsupportedOperationException();
    }

    public CheckedFuture<CertificateGrantType, ServiceException> get(String id, HttpContext httpContext) {
        throw new UnsupportedOperationException();
    }

    public CheckedFuture<CertificateGrantType, ServiceException> persist(CertificateGrantType resource, HttpContext httpContext) {
        throw new UnsupportedOperationException();
    }

    public CheckedFuture<List<CertificateGrantType>, ServiceException> search(Multimap<String, String> searchCriteria, SortCriteria sortCriteria, Page page, HttpContext httpContext) {
        throw new UnsupportedOperationException();
    }

    public CheckedFuture<List<CertificateGrantType>, ServiceException> search(Multimap<String, String> searchCriteria, SortCriteria sortCriteria, Page page, HttpContext httpContext, MediaType mediaType, String searchResourcesEndPoint) {
        throw new UnsupportedOperationException();
    }
}

