/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.oauth.client.token;

import com.covisint.core.http.service.client.BaseResourceClient;
import com.covisint.core.http.service.client.ClientException;
import com.covisint.core.http.service.core.Page;
import com.covisint.core.http.service.core.ServiceException;
import com.covisint.core.http.service.core.SortCriteria;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NotEmpty;
import com.covisint.core.support.constraint.Nullable;
import com.covisint.core.support.primitive.StringSupport;
import com.covisint.platform.oauth.client.token.TokenClient;
import com.covisint.platform.oauth.core.SupportedMediaType;
import com.covisint.platform.oauth.core.token.Token;
import com.damnhandy.uri.template.UriTemplate;
import com.damnhandy.uri.template.VariableExpansionException;
import com.google.common.base.Charsets;
import com.google.common.collect.Multimap;
import com.google.common.net.MediaType;
import com.google.common.util.concurrent.CheckedFuture;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenClientImpl
extends BaseResourceClient<Token>
implements TokenClient {
    private static final String APPLICATION_ID_HEADER = "application-id";
    private static final MediaType TOKEN_V1_MEDIA_TYPE = MediaType.parse((String)SupportedMediaType.TOKEN_MT.value());
    private static final Charset UTF8 = Charsets.UTF_8;
    private static final String BASIC = "Basic ";
    private static final String AUTHORIZATION = "Authorization";
    private final Logger log = LoggerFactory.getLogger(TokenClientImpl.class);
    private UriTemplate getTokenUriTemplate;
    private UriTemplate postTokenUriTemplate;
    private String appId;

    public void setGetTokenUriTemplate(UriTemplate uriTemplate) {
        this.getTokenUriTemplate = uriTemplate;
    }

    public void setPostTokenUriTemplate(UriTemplate uriTemplate) {
        this.postTokenUriTemplate = uriTemplate;
    }

    public void setApplicationId(@Nonnull @NotEmpty String newAppId) {
        this.appId = newAppId;
    }

    @Nonnull
    @NotEmpty
    private String getAuthorization(@Nonnull @NotEmpty String clientId, @Nonnull @NotEmpty String clientSecret) {
        String credentials = MessageFormat.format("{0}:{1}", clientId, clientSecret);
        byte[] autorizationBytes = credentials.getBytes(UTF8);
        String authorization = BASIC.concat(new String(Base64.encodeBase64((byte[])autorizationBytes), UTF8));
        return authorization;
    }

    @Override
    @Nonnull
    public CheckedFuture<Token, ServiceException> getToken(@Nonnull @NotEmpty String clientId, String clientSecret, @Nonnull HttpContext httpContext) {
        return this.postAccessToken(clientId, clientSecret, httpContext);
    }

    @Override
    @Nonnull
    public CheckedFuture<Token, ServiceException> postAccessToken(@Nonnull @NotEmpty String clientId, @Nonnull @NotEmpty String clientSecret, @Nonnull HttpContext httpContext) {
        try {
            String url = this.postTokenUriTemplate.expand();
            HttpPost post = new HttpPost(url);
            post.setHeader(AUTHORIZATION, this.getAuthorization(clientId, clientSecret));
            post.setHeader("type", "client_credentials");
            if (StringSupport.trimOrNull((String)this.appId) != null) {
                post.setHeader(APPLICATION_ID_HEADER, this.appId);
            }
            return this.execute((HttpUriRequest)post, TOKEN_V1_MEDIA_TYPE, httpContext);
        }
        catch (VariableExpansionException e) {
            this.log.error("Error occurred while expanding URL template.", (Throwable)e);
            throw new ClientException("Error occurred while expanding URL template.");
        }
    }

    @Override
    @Nonnull
    public CheckedFuture<Token, ServiceException> getToken(@Nonnull @NotEmpty String clientId, @Nullable String certificate, @Nullable String publickey, @Nullable String x509RequestAttributeName, @Nonnull HttpContext httpContext) {
        try {
            String url = this.getTokenUriTemplate.expand();
            HttpGet get = new HttpGet(url);
            get.setHeader("clientId", clientId);
            get.setHeader("X-Client-Cert", certificate);
            get.setHeader("publicKey", publickey);
            get.setHeader("javax.servlet.request.X509Certificate", x509RequestAttributeName);
            get.setHeader("type", "certificate");
            return this.execute((HttpUriRequest)get, TOKEN_V1_MEDIA_TYPE, httpContext);
        }
        catch (VariableExpansionException e) {
            this.log.error("Error occurred while expanding URL template.", (Throwable)e);
            throw new ClientException("Error occurred while expanding URL template.");
        }
    }

    @Override
    @Nonnull
    public CheckedFuture<Token, ServiceException> postAccessToken(@Nonnull @NotEmpty String clientId, @Nullable String certificate, @Nullable String publickey, @Nullable String x509RequestAttributeName, @Nonnull HttpContext httpContext) {
        try {
            String url = this.getTokenUriTemplate.expand();
            HttpPost post = new HttpPost(url);
            post.setHeader("clientId", clientId);
            post.setHeader("X-Client-Cert", certificate);
            post.setHeader("publicKey", publickey);
            post.setHeader("javax.servlet.request.X509Certificate", x509RequestAttributeName);
            post.setHeader("type", "certificate");
            return this.execute((HttpUriRequest)post, TOKEN_V1_MEDIA_TYPE, httpContext);
        }
        catch (VariableExpansionException e) {
            this.log.error("Error occurred while expanding URL template.", (Throwable)e);
            throw new ClientException("Error occurred while expanding URL template.");
        }
    }

    public CheckedFuture<Token, ServiceException> add(Token resource, HttpContext httpContext) {
        throw new UnsupportedOperationException();
    }

    public CheckedFuture<Token, ServiceException> delete(String id, HttpContext httpContext) {
        throw new UnsupportedOperationException();
    }

    public CheckedFuture<Token, ServiceException> get(String id, HttpContext httpContext) {
        throw new UnsupportedOperationException();
    }

    public CheckedFuture<Token, ServiceException> get(Token resource, HttpContext httpContext) {
        throw new UnsupportedOperationException();
    }

    public CheckedFuture<Token, ServiceException> persist(Token resource, HttpContext httpContext) {
        throw new UnsupportedOperationException();
    }

    public CheckedFuture<List<Token>, ServiceException> search(Multimap<String, String> searchCriteria, SortCriteria sortCriteria, Page page, HttpContext httpContext) {
        throw new UnsupportedOperationException();
    }

    public CheckedFuture<List<Token>, ServiceException> search(Multimap<String, String> searchCriteria, SortCriteria sortCriteria, Page page, HttpContext httpContext, MediaType mediaType, String searchResourcesEndPoint) {
        throw new UnsupportedOperationException();
    }
}

