/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.oauth.client.token.sdk;

import com.covisint.core.http.service.core.ServiceException;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NotEmpty;
import com.covisint.core.support.primitive.StringSupport;
import com.covisint.platform.oauth.client.token.TokenClientBuilder;
import com.covisint.platform.oauth.client.token.TokenClientFactory;
import com.covisint.platform.oauth.client.token.TokenClientImpl;
import com.covisint.platform.oauth.client.token.sdk.AuthConfigurationProvider;
import com.covisint.platform.oauth.client.token.sdk.DefaultAuthConfigurationProvider;
import com.covisint.platform.oauth.core.token.Token;
import com.google.common.util.concurrent.CheckedFuture;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;

public class TokenSDK
extends TokenClientFactory {
    private AuthConfigurationProvider authConfigProvider;

    public TokenSDK(@Nonnull @NotEmpty String serviceUrl) {
        super(serviceUrl);
    }

    @Nonnull
    protected AuthConfigurationProvider getAuthConfigProvider() {
        if (this.authConfigProvider == null) {
            this.authConfigProvider = new DefaultAuthConfigurationProvider();
        }
        return this.authConfigProvider;
    }

    @Override
    protected TokenClientImpl buildResourceClient(TokenClientBuilder builder) {
        TokenClientImpl client = super.buildResourceClient(builder);
        String appId = this.getAuthConfigProvider().getApplicationId();
        if (StringSupport.trimOrNull((String)appId) != null) {
            client.setApplicationId(appId);
        }
        return client;
    }

    public TokenClientImpl create() {
        throw new UnsupportedOperationException("Please use #newClient to create new client instances.");
    }

    @Nonnull
    public TokenClient newClient() {
        return new ClientImpl((TokenClientImpl)super.create());
    }

    public TokenSDK setAuthConfigProvider(@Nonnull AuthConfigurationProvider provider) {
        this.authConfigProvider = provider;
        return this;
    }

    private static final class ClientImpl
    implements TokenClient {
        private final TokenClientImpl delegate;

        private ClientImpl(@Nonnull TokenClientImpl newDelegate) {
            this.delegate = newDelegate;
        }

        @Override
        @Nonnull
        public CheckedFuture<Token, ServiceException> getToken(@Nonnull @NotEmpty String clientId, @Nonnull @NotEmpty String clientSecret) {
            return this.delegate.postAccessToken(clientId, clientSecret, (HttpContext)new BasicHttpContext());
        }
    }

    public static interface TokenClient {
        @Nonnull
        public CheckedFuture<Token, ServiceException> getToken(@Nonnull @NotEmpty String var1, @Nonnull @NotEmpty String var2);
    }
}

