/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.user.core.person.account.password.io.json;

import com.covisint.core.http.service.core.ResourceReference;
import com.covisint.core.http.service.core.io.jsonp.AbstractRealmScopedResourceReader;
import com.covisint.core.http.service.core.io.jsonp.JsonpSupport;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.platform.user.core.person.PersonJsonSupport;
import com.covisint.platform.user.core.person.SupportedMediaType;
import com.covisint.platform.user.core.person.account.password.PasswordAccount;
import com.google.common.net.MediaType;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;

public class PasswordAccountReader
extends AbstractRealmScopedResourceReader<PasswordAccount> {
    @Nonnull
    protected PasswordAccount createResource(MediaType mediaType) {
        return new PasswordAccount();
    }

    protected PasswordAccount readResource(@Nonnull MediaType mediaType, @Nonnull JsonObject json) {
        JsonNumber numberProperty;
        ResourceReference authnticationPolicy;
        ResourceReference passwordPolicy;
        PasswordAccount passwordAccount = (PasswordAccount)super.readResource(mediaType, json);
        JsonString stringProperty = json.getJsonString("username");
        if (!JsonpSupport.isJsonStringPropertyEmptyOrNull((JsonString)stringProperty)) {
            passwordAccount.setUsername(stringProperty.getString());
        }
        if (!JsonpSupport.isJsonStringPropertyEmptyOrNull((JsonString)(stringProperty = json.getJsonString("password")))) {
            passwordAccount.setPassword(stringProperty.getString());
        }
        if ((passwordPolicy = PasswordAccountReader.readResourceReference((JsonObject)json.getJsonObject("passwordPolicy"))) != null) {
            passwordAccount.setPasswordPolicy(passwordPolicy);
        }
        if ((authnticationPolicy = PasswordAccountReader.readResourceReference((JsonObject)json.getJsonObject("authenticationPolicy"))) != null) {
            passwordAccount.setAuthnPolicy(authnticationPolicy);
        }
        if ((numberProperty = json.getJsonNumber("expiration")) != null) {
            passwordAccount.setExpirationInstant(numberProperty.longValue());
        }
        if ((numberProperty = json.getJsonNumber("unlockInstant")) != null) {
            passwordAccount.setUnlockInstant(numberProperty.longValue());
        }
        passwordAccount.setLocked(json.getBoolean("locked", false));
        return passwordAccount;
    }

    @Nonnull
    public Class<PasswordAccount> getResourceType() {
        return PasswordAccount.class;
    }

    public boolean isReadable(MediaType mediaType) {
        return PersonJsonSupport.isMediaTypeSame(SupportedMediaType.PASSWORD_ACCOUNT_MT, mediaType);
    }
}

