/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.user.core.person.invitation;

import com.covisint.core.http.service.core.AbstractRealmScopedResource;
import com.covisint.core.http.service.core.ResourceReference;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NotEmpty;
import com.covisint.core.support.constraint.Nullable;
import com.covisint.core.support.constraint.Searchable;
import com.covisint.core.support.primitive.StringSupport;
import com.google.common.base.Objects;

public class PersonInvitation
extends AbstractRealmScopedResource<PersonInvitation> {
    private static final long serialVersionUID = -7239491174367422203L;
    private String email;
    @Searchable
    private ResourceReference invitor;
    @Searchable
    private ResourceReference invitee;
    private ResourceReference targetOrganization;
    private String invitationCode;
    private long invitationPin;
    private String inviteType;

    @Nullable
    public String getEmail() {
        return this.email;
    }

    @Nonnull
    public PersonInvitation setEmail(@Nonnull @NotEmpty String emailAddress) {
        this.email = StringSupport.trim((String)emailAddress);
        return this;
    }

    @Nullable
    public ResourceReference getInvitor() {
        return this.invitor;
    }

    @Nonnull
    public PersonInvitation setInvitor(@Nonnull ResourceReference newInvitor) {
        this.invitor = newInvitor;
        return this;
    }

    @Nonnull
    public PersonInvitation setInvitorId(@Nonnull @NotEmpty String id) {
        this.invitor = new ResourceReference(id, "person");
        return this;
    }

    @Nullable
    public ResourceReference getInvitee() {
        return this.invitee;
    }

    @Nonnull
    public PersonInvitation setInvitee(@Nonnull ResourceReference newInvitee) {
        this.invitee = newInvitee;
        return this;
    }

    @Nonnull
    public PersonInvitation setInviteeId(@Nonnull @NotEmpty String inviteeId) {
        this.invitee = new ResourceReference(inviteeId, "person");
        return this;
    }

    @Nullable
    public ResourceReference getTargetOrganization() {
        return this.targetOrganization;
    }

    @Nonnull
    public PersonInvitation setTargetOrganization(@Nonnull ResourceReference newTargetOrganization) {
        this.targetOrganization = newTargetOrganization;
        return this;
    }

    @Nonnull
    public PersonInvitation setTargetOrganizationId(@Nonnull @NotEmpty String organizationId) {
        this.targetOrganization = new ResourceReference(organizationId, "organization");
        return this;
    }

    @Nullable
    public String getInvitationCode() {
        return this.invitationCode;
    }

    @Nonnull
    public PersonInvitation setInvitationCode(@Nonnull @NotEmpty String code) {
        this.invitationCode = StringSupport.trimOrNull((String)code);
        return this;
    }

    public long getInvitationPin() {
        return this.invitationPin;
    }

    @Nonnull
    public PersonInvitation setInvitationPin(long pin) {
        this.invitationPin = pin;
        return this;
    }

    @Nullable
    public String getInviteType() {
        return this.inviteType;
    }

    @Nonnull
    public PersonInvitation setInviteType(@Nonnull @NotEmpty String type) {
        this.inviteType = type;
        return this;
    }

    public final boolean equals(@Nonnull Object obj) {
        return this.isResourceIdentityEqual(PersonInvitation.class, obj);
    }

    public final int hashCode() {
        return this.getResourceIdentityHashCode();
    }

    @Nonnull
    @NotEmpty
    public final String toString() {
        return this.populateToStringHelper(Objects.toStringHelper((Object)((Object)this))).add("email", (Object)this.email).add("invitor", (Object)this.invitor).add("inviteeId", (Object)this.invitee).add("targetOrganization", (Object)this.targetOrganization).add("invitationCode", (Object)this.invitationCode).add("invitationPin", this.invitationPin).add("inviteType", (Object)this.inviteType).toString();
    }
}

