/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.user.core.person.invitation.io.json;

import com.covisint.core.http.service.core.ResourceReference;
import com.covisint.core.http.service.core.io.jsonp.AbstractRealmScopedResourceReader;
import com.covisint.core.http.service.core.io.jsonp.JsonpSupport;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.platform.user.core.person.PersonJsonSupport;
import com.covisint.platform.user.core.person.SupportedMediaType;
import com.covisint.platform.user.core.person.invitation.PersonInvitation;
import com.google.common.net.MediaType;
import javax.json.JsonObject;
import javax.json.JsonString;

public class PersonInvitationReader
extends AbstractRealmScopedResourceReader<PersonInvitation> {
    @Nonnull
    protected final PersonInvitation createResource(@Nonnull MediaType mediaType) {
        return new PersonInvitation();
    }

    @Nonnull
    protected final PersonInvitation readResource(@Nonnull MediaType mediaType, @Nonnull JsonObject json) {
        ResourceReference targetOrganization;
        ResourceReference invitee;
        ResourceReference invitor;
        PersonInvitation personInvitation = (PersonInvitation)super.readResource(mediaType, json);
        JsonString jsonString = json.getJsonString("email");
        if (!JsonpSupport.isJsonStringPropertyEmptyOrNull((JsonString)jsonString)) {
            personInvitation.setEmail(jsonString.getString());
        }
        if ((invitor = PersonInvitationReader.readResourceReference((JsonObject)json.getJsonObject("invitor"))) != null) {
            personInvitation.setInvitor(invitor);
        }
        if ((invitee = PersonInvitationReader.readResourceReference((JsonObject)json.getJsonObject("invitee"))) != null) {
            personInvitation.setInvitee(invitee);
        }
        if ((targetOrganization = PersonInvitationReader.readResourceReference((JsonObject)json.getJsonObject("targetOrganization"))) != null) {
            personInvitation.setTargetOrganization(targetOrganization);
        }
        return personInvitation;
    }

    @Nonnull
    public final Class<PersonInvitation> getResourceType() {
        return PersonInvitation.class;
    }

    public final boolean isReadable(@Nonnull MediaType mediaType) {
        return PersonJsonSupport.isMediaTypeSame(SupportedMediaType.PERSON_INVITATION_MT, mediaType);
    }
}

