/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.user.core.person.io.json;

import com.covisint.core.http.service.core.AbstractRealmScopedResource;
import com.covisint.core.http.service.core.io.jsonp.AbstractRealmScopedResourceWriter;
import com.covisint.core.http.service.core.io.jsonp.JsonpSupport;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.Nullable;
import com.covisint.core.support.primitive.StringSupport;
import com.covisint.platform.legacy.address.Address;
import com.covisint.platform.legacy.phone.Phones;
import com.covisint.platform.user.core.person.Person;
import com.covisint.platform.user.core.person.PersonJsonSupport;
import com.covisint.platform.user.core.person.SupportedMediaType;
import com.google.common.net.MediaType;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;

public class PersonWriter
extends AbstractRealmScopedResourceWriter<Person> {
    private JsonObjectBuilder writeName(Person src) {
        JsonObjectBuilder json = Json.createObjectBuilder();
        JsonpSupport.addPropertyIfNonnullValue((JsonObjectBuilder)json, (String)"prefix", (String)src.getNamePrefix());
        JsonpSupport.addPropertyIfNonnullValue((JsonObjectBuilder)json, (String)"given", (String)src.getGivenName());
        JsonpSupport.addPropertyIfNonnullValue((JsonObjectBuilder)json, (String)"middle", (String)src.getMiddleName());
        JsonpSupport.addPropertyIfNonnullValue((JsonObjectBuilder)json, (String)"surname", (String)src.getSurname());
        JsonpSupport.addPropertyIfNonnullValue((JsonObjectBuilder)json, (String)"suffix", (String)src.getNameSuffix());
        return json;
    }

    private JsonObject writeAddress(Person src) {
        JsonObjectBuilder parent = Json.createObjectBuilder();
        JsonArray streets = this.writeStreets(src.getMainAddress());
        if (streets != null && !streets.isEmpty()) {
            parent.add("streets", (JsonValue)streets);
        }
        JsonpSupport.addPropertyIfNonnullValue((JsonObjectBuilder)parent, (String)"city", (String)src.getMainAddress().getCity());
        JsonpSupport.addPropertyIfNonnullValue((JsonObjectBuilder)parent, (String)"state", (String)src.getMainAddress().getState());
        JsonpSupport.addPropertyIfNonnullValue((JsonObjectBuilder)parent, (String)"postal", (String)src.getMainAddress().getPostal());
        JsonpSupport.addPropertyIfNonnullValue((JsonObjectBuilder)parent, (String)"country", (String)src.getMainAddress().getCountry());
        return parent.build();
    }

    private JsonArray writeStreets(Address address) {
        JsonArrayBuilder streets = Json.createArrayBuilder();
        if (address.getAddress1() != null) {
            streets.add(address.getAddress1());
        }
        if (address.getAddress2() != null) {
            streets.add(address.getAddress2());
        }
        if (address.getAddress3() != null) {
            streets.add(address.getAddress3());
        }
        return streets.build();
    }

    private void writePhones(Person src, JsonObjectBuilder json) {
        JsonArrayBuilder phonesJson = Json.createArrayBuilder();
        for (String phoneType : Phones.SUPPORTED_PHONE_TYPES) {
            String number = src.getPhones().getByType(phoneType);
            if (StringSupport.trimOrNull((String)number) == null) continue;
            phonesJson.add((JsonValue)Json.createObjectBuilder().add("type", phoneType).add("number", number).build());
        }
        JsonArray phones = phonesJson.build();
        if (!phones.isEmpty()) {
            json.add("phones", (JsonValue)phones);
        }
    }

    protected JsonObjectBuilder writeResource(@Nonnull MediaType mediaType, @Nonnull Person resource) {
        JsonObjectBuilder builder = super.writeResource(mediaType, (AbstractRealmScopedResource)resource);
        if (resource.getStatus() != null) {
            JsonpSupport.addPropertyIfNonnullValue((JsonObjectBuilder)builder, (String)"status", (String)resource.getStatus().name().toLowerCase());
        }
        builder.add("name", this.writeName(resource));
        JsonArrayBuilder addresses = Json.createArrayBuilder();
        JsonObject addressJson = this.writeAddress(resource);
        if (addressJson.size() > 0) {
            addresses.add((JsonValue)addressJson);
            builder.add("addresses", addresses);
        }
        JsonpSupport.addPropertyIfNonnullValue((JsonObjectBuilder)builder, (String)"language", (String)resource.getPreferredLanguage());
        JsonpSupport.addPropertyIfNonnullValue((JsonObjectBuilder)builder, (String)"timezone", (String)resource.getPreferredTimezone());
        this.writePhones(resource, builder);
        JsonpSupport.addPropertyIfNonnullValue((JsonObjectBuilder)builder, (String)"title", (String)resource.getJobTitle());
        JsonpSupport.addPropertyIfNonnullValue((JsonObjectBuilder)builder, (String)"email", (String)resource.getEmail());
        if (resource.getOrganization() != null) {
            this.writeResourceReference("organization", resource.getOrganization(), builder);
        }
        if (resource.getPreferredCurrency() != null) {
            JsonpSupport.addPropertyIfNonnullValue((JsonObjectBuilder)builder, (String)"currency", (String)resource.getPreferredCurrency().getCode());
        }
        return builder;
    }

    @Nonnull
    public Class<Person> getResourceType() {
        return Person.class;
    }

    public boolean isWritable(@Nullable Class clazz, @Nonnull MediaType mediaType) {
        return PersonJsonSupport.isMediaTypeSame(SupportedMediaType.PERSON_MT, mediaType);
    }
}

