/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.user.core.person.request;

import com.covisint.core.http.service.core.AbstractRealmScopedResource;
import com.covisint.core.http.service.core.ResourceReference;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NotEmpty;
import com.covisint.core.support.constraint.Nullable;
import com.covisint.core.support.constraint.Searchable;
import com.covisint.core.support.primitive.StringSupport;
import com.google.common.base.Objects;

public class PersonRequest
extends AbstractRealmScopedResource<PersonRequest> {
    private static final long serialVersionUID = 1L;
    @Searchable
    private ResourceReference registrant;
    private String justification;
    private String packageId;
    private String packageRealm;
    private String code;
    private String codeKind;
    private int requestTypeEnum;
    private String isGroupMaster;
    private String additionalInfo;
    private String codeEntered;
    private long targetOrgId;
    private long subjectUserId;
    private int workflowCurrentPhaseEnum;
    private String accessLevel;
    private long requestRoleId;
    private long requestedStatusEnum;
    private long targetUserId;

    @Nullable
    public ResourceReference getRegistrant() {
        return this.registrant;
    }

    @Nonnull
    public PersonRequest setRegistrant(@Nonnull ResourceReference newRegistrant) {
        this.registrant = newRegistrant;
        return this;
    }

    @Nonnull
    public PersonRequest setRegistrant(@Nonnull @NotEmpty String registrantId) {
        this.registrant = new ResourceReference(registrantId, "person");
        return this;
    }

    @Nullable
    public String getJustification() {
        return this.justification;
    }

    @Nonnull
    public PersonRequest setJustification(@Nonnull @NotEmpty String justificationString) {
        this.justification = StringSupport.trim((String)justificationString);
        return this;
    }

    @Nullable
    public String getPackageId() {
        return this.packageId;
    }

    @Nonnull
    public PersonRequest setPackageId(@Nonnull @NotEmpty String id) {
        this.packageId = StringSupport.trim((String)id);
        return this;
    }

    @Nullable
    public String getPackageRealm() {
        return this.packageRealm;
    }

    @Nonnull
    public PersonRequest setPackageRealm(@Nullable String realm) {
        this.packageRealm = StringSupport.trim((String)realm);
        return this;
    }

    @Nullable
    public String getCode() {
        return this.code;
    }

    @Nonnull
    public PersonRequest setCode(@Nullable String codeString) {
        this.code = StringSupport.trim((String)codeString);
        return this;
    }

    @Nullable
    public String getCodeKind() {
        return this.codeKind;
    }

    @Nonnull
    public PersonRequest setCodeKind(@Nullable String kind) {
        this.codeKind = StringSupport.trim((String)kind);
        return this;
    }

    public int getRequestTypeEnum() {
        return this.requestTypeEnum;
    }

    @Nonnull
    public PersonRequest setRequestTypeEnum(int requestEnum) {
        this.requestTypeEnum = requestEnum;
        return this;
    }

    @Nullable
    public String getIsGroupMaster() {
        return this.isGroupMaster;
    }

    @Nonnull
    public PersonRequest setIsGroupMaster(String groupMaster) {
        this.isGroupMaster = groupMaster;
        return this;
    }

    @Nullable
    public String getAdditionalInfo() {
        return this.additionalInfo;
    }

    @Nonnull
    public PersonRequest setAdditionalInfo(@Nullable String info) {
        this.additionalInfo = info;
        return this;
    }

    @Nullable
    public String getCodeEntered() {
        return this.codeEntered;
    }

    @Nonnull
    public PersonRequest setCodeEntered(@Nullable String enteredCode) {
        this.codeEntered = enteredCode;
        return this;
    }

    public long getTargetOrgId() {
        return this.targetOrgId;
    }

    @Nonnull
    public PersonRequest setTargetOrgId(long targetOrganizationId) {
        this.targetOrgId = targetOrganizationId;
        return this;
    }

    public long getSubjectUserId() {
        return this.subjectUserId;
    }

    @Nonnull
    public PersonRequest setSubjectUserId(long subjectId) {
        this.subjectUserId = subjectId;
        return this;
    }

    public int getWorkflowCurrentPhaseEnum() {
        return this.workflowCurrentPhaseEnum;
    }

    @Nullable
    public PersonRequest setWorkflowCurrentPhaseEnum(int phaseEnum) {
        this.workflowCurrentPhaseEnum = phaseEnum;
        return this;
    }

    @Nullable
    public String getAccessLevel() {
        return this.accessLevel;
    }

    @Nonnull
    public PersonRequest setAccessLevel(@Nullable String level) {
        this.accessLevel = level;
        return this;
    }

    public long getRequestRoleId() {
        return this.requestRoleId;
    }

    @Nonnull
    public PersonRequest setRequestRoleId(long roleId) {
        this.requestRoleId = roleId;
        return this;
    }

    public long getRequestedStatusEnum() {
        return this.requestedStatusEnum;
    }

    @Nonnull
    public PersonRequest setRequestedStatusEnum(long statusEnum) {
        this.requestedStatusEnum = statusEnum;
        return this;
    }

    public long getTargetUserId() {
        return this.targetUserId;
    }

    @Nonnull
    public PersonRequest setTargetUserId(long targetId) {
        this.targetUserId = targetId;
        return this;
    }

    public boolean equals(Object obj) {
        return this.isResourceIdentityEqual(PersonRequest.class, obj);
    }

    public int hashCode() {
        return this.getResourceIdentityHashCode();
    }

    @Nonnull
    @NotEmpty
    public String toString() {
        return this.populateToStringHelper(Objects.toStringHelper((Object)((Object)this))).add("registrant", (Object)this.registrant).add("justification", (Object)this.justification).add("packageId", (Object)this.packageId).add("code", (Object)this.code).add("codeKind", (Object)this.codeKind).add("requestTypeEnum", this.requestTypeEnum).add("isGroupMaster", (Object)this.isGroupMaster).add("additionalInfo", (Object)this.additionalInfo).add("codeEntered", (Object)this.codeEntered).add("targetOrgId", this.targetOrgId).add("subjectUserId", this.subjectUserId).add("workflowCurrentPhaseEnum", this.workflowCurrentPhaseEnum).add("accessLevel", (Object)this.accessLevel).add("requestRoleId", this.requestRoleId).add("requestedStatusEnum", this.requestedStatusEnum).add("targetUserId", this.targetUserId).toString();
    }
}

