/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.user.client.person;

import com.covisint.core.http.service.client.BaseResourceClient;
import com.covisint.core.http.service.client.ClientException;
import com.covisint.core.http.service.core.ServiceException;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NotEmpty;
import com.covisint.platform.user.client.person.PersonClient;
import com.covisint.platform.user.core.person.Person;
import com.damnhandy.uri.template.UriTemplate;
import com.damnhandy.uri.template.VariableExpansionException;
import com.google.common.net.MediaType;
import com.google.common.util.concurrent.CheckedFuture;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersonClientImpl
extends BaseResourceClient<Person>
implements PersonClient {
    private static final String PERSON_ID = "personId";
    private final Logger log = LoggerFactory.getLogger(PersonClientImpl.class);
    private UriTemplate activateEndpointTemplate;
    private UriTemplate suspendEndpointTemplate;
    private UriTemplate unsuspendEndpointTemplate;

    private CheckedFuture<Void, ServiceException> executePost(@Nonnull @NotEmpty String personId, @Nonnull HttpContext context, @Nonnull UriTemplate uriTemplate) {
        try {
            String url = uriTemplate.set(PERSON_ID, (Object)personId).expand();
            return this.execute((HttpUriRequest)new HttpPost(url), MediaType.ANY_APPLICATION_TYPE, context);
        }
        catch (VariableExpansionException e) {
            String errorMessage = "Error occurred while expanding URL template.";
            this.log.error("Error occurred while expanding URL template.", (Throwable)e);
            throw new ClientException("Error occurred while expanding URL template.");
        }
    }

    @Override
    public final CheckedFuture<Void, ServiceException> activate(@Nonnull @NotEmpty String personId, @Nonnull HttpContext context) {
        return this.executePost(personId, context, this.activateEndpointTemplate);
    }

    @Override
    public final CheckedFuture<Void, ServiceException> suspend(@Nonnull @NotEmpty String personId, @Nonnull HttpContext context) {
        return this.executePost(personId, context, this.suspendEndpointTemplate);
    }

    @Override
    public final CheckedFuture<Void, ServiceException> unsuspend(@Nonnull @NotEmpty String personId, @Nonnull HttpContext context) {
        return this.executePost(personId, context, this.unsuspendEndpointTemplate);
    }

    public final void setActivateEndpointTemplate(@Nonnull UriTemplate template) {
        this.activateEndpointTemplate = template;
    }

    public final void setSuspendEndpointTemplate(@Nonnull UriTemplate template) {
        this.suspendEndpointTemplate = template;
    }

    public final void setUnsuspendEndpointTemplate(@Nonnull UriTemplate template) {
        this.unsuspendEndpointTemplate = template;
    }

    public final CheckedFuture<Person, ServiceException> delete(String id, HttpContext httpContext) {
        throw new UnsupportedOperationException();
    }
}

