/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.user.client.person.invitation;

import com.covisint.core.http.service.client.BaseResourceClient;
import com.covisint.core.http.service.client.ClientException;
import com.covisint.core.http.service.core.ServiceException;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NotEmpty;
import com.covisint.platform.user.client.person.invitation.PersonInvitationClient;
import com.covisint.platform.user.core.person.invitation.PersonInvitation;
import com.damnhandy.uri.template.UriTemplate;
import com.damnhandy.uri.template.VariableExpansionException;
import com.google.common.net.MediaType;
import com.google.common.util.concurrent.CheckedFuture;
import java.util.HashMap;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersonInvitationClientImpl
extends BaseResourceClient<PersonInvitation>
implements PersonInvitationClient {
    private final Logger log = LoggerFactory.getLogger(PersonInvitationClientImpl.class);
    private UriTemplate acceptEndpointTemplate;

    @Override
    public final CheckedFuture<Void, ServiceException> accept(@Nonnull @NotEmpty String inviteId, @Nonnull @NotEmpty String createdPersonId, @Nonnull HttpContext context) {
        try {
            HashMap<String, String> queryParameters = new HashMap<String, String>();
            queryParameters.put("inviteId", inviteId);
            queryParameters.put("createdPersonId", createdPersonId);
            String url = this.acceptEndpointTemplate.set(queryParameters).expand();
            return this.execute((HttpUriRequest)new HttpPost(url), MediaType.ANY_APPLICATION_TYPE, context);
        }
        catch (VariableExpansionException e) {
            String urlExpansionException = "Error occurred while expanding URL template.";
            this.log.error("Error occurred while expanding URL template.", (Throwable)e);
            throw new ClientException("Error occurred while expanding URL template.");
        }
    }

    public final void setAcceptEndpointTemplate(@Nonnull UriTemplate template) {
        this.acceptEndpointTemplate = template;
    }

    public final CheckedFuture<PersonInvitation, ServiceException> persist(PersonInvitation resource, HttpContext httpContext) {
        throw new UnsupportedOperationException();
    }
}

