/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.user.client.person.request;

import com.covisint.core.http.service.client.BaseResourceClient;
import com.covisint.core.http.service.client.ClientException;
import com.covisint.core.http.service.core.ServiceException;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NotEmpty;
import com.covisint.platform.user.client.person.request.PersonRequestClient;
import com.covisint.platform.user.core.person.request.PersonRequest;
import com.damnhandy.uri.template.UriTemplate;
import com.damnhandy.uri.template.VariableExpansionException;
import com.google.common.net.MediaType;
import com.google.common.util.concurrent.CheckedFuture;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersonRequestClientImpl
extends BaseResourceClient<PersonRequest>
implements PersonRequestClient {
    private final Logger log = LoggerFactory.getLogger(PersonRequestClientImpl.class);
    private UriTemplate personRequestApproveUriTemplate;

    final void setPersonRequestApproveUriTemplate(@Nonnull UriTemplate template) {
        this.personRequestApproveUriTemplate = template;
    }

    @Override
    public final CheckedFuture<Void, ServiceException> approve(@Nonnull @NotEmpty String requestId, @Nonnull HttpContext context) {
        try {
            String url = this.personRequestApproveUriTemplate.set("requestId", (Object)requestId).expand();
            return this.execute((HttpUriRequest)new HttpPost(url), MediaType.ANY_APPLICATION_TYPE, context);
        }
        catch (VariableExpansionException e) {
            String errorMsg = "Error occurred while expanding URL template.";
            this.log.error("Error occurred while expanding URL template.", (Throwable)e);
            throw new ClientException("Error occurred while expanding URL template.");
        }
    }

    public final CheckedFuture<PersonRequest, ServiceException> persist(PersonRequest resource, HttpContext httpContext) {
        throw new UnsupportedOperationException();
    }
}

