/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.user.client.sdk;

import com.covisint.core.http.service.core.Page;
import com.covisint.core.http.service.core.Resource;
import com.covisint.core.http.service.core.ServiceException;
import com.covisint.core.http.service.core.SortCriteria;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NotEmpty;
import com.covisint.core.support.httpclient.HttpClientBuilder;
import com.covisint.platform.oauth.client.token.sdk.AuthConfigurationProvider;
import com.covisint.platform.oauth.client.token.sdk.DefaultAuthConfigurationProvider;
import com.covisint.platform.oauth.client.token.sdk.TokenSupplier;
import com.covisint.platform.user.client.person.invitation.PersonInvitationClientFactory;
import com.covisint.platform.user.client.person.invitation.PersonInvitationClientImpl;
import com.covisint.platform.user.core.person.invitation.PersonInvitation;
import com.google.common.base.Supplier;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.CheckedFuture;
import java.util.List;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;

public class PersonInvitationSDK
extends PersonInvitationClientFactory {
    private AuthConfigurationProvider authConfigProvider;

    public PersonInvitationSDK(@Nonnull @NotEmpty String serviceUrl) {
        super(serviceUrl);
    }

    @Nonnull
    protected AuthConfigurationProvider getAuthConfigProvider() {
        if (this.authConfigProvider == null) {
            this.authConfigProvider = new DefaultAuthConfigurationProvider();
        }
        return this.authConfigProvider;
    }

    protected HttpClientBuilder populateHttpClientBuilder(@Nonnull HttpClientBuilder builder) {
        TokenSupplier tokenSupplier = new TokenSupplier(this.getAuthConfigProvider());
        builder.addAuthorizationTokenInterceptor((Supplier)tokenSupplier);
        return builder;
    }

    public PersonInvitationSDK setAuthConfigProvider(@Nonnull AuthConfigurationProvider provider) {
        this.authConfigProvider = provider;
        return this;
    }

    public PersonInvitationClientImpl create() {
        throw new UnsupportedOperationException("Please use #newClient to create new client instances.");
    }

    @Nonnull
    public PersonInvitationClient newClient() {
        return new ClientImpl((PersonInvitationClientImpl)super.create());
    }

    private static final class ClientImpl
    implements PersonInvitationClient {
        private final PersonInvitationClientImpl delegate;

        private ClientImpl(@Nonnull PersonInvitationClientImpl newDelegate) {
            this.delegate = newDelegate;
        }

        @Override
        @Nonnull
        public CheckedFuture<PersonInvitation, ServiceException> get(@Nonnull @NotEmpty String inviteId) {
            return this.delegate.get(inviteId, (HttpContext)new BasicHttpContext());
        }

        @Override
        @Nonnull
        public CheckedFuture<PersonInvitation, ServiceException> add(@Nonnull PersonInvitation invite) {
            return this.delegate.add((Resource)invite, (HttpContext)new BasicHttpContext());
        }

        @Override
        @Nonnull
        public CheckedFuture<PersonInvitation, ServiceException> delete(@Nonnull @NotEmpty String inviteId) {
            return this.delegate.delete(inviteId, (HttpContext)new BasicHttpContext());
        }

        @Override
        @Nonnull
        public CheckedFuture<List<PersonInvitation>, ServiceException> search(List<String> inviteeIds, List<String> invitorIds, @Nonnull Page page) {
            ArrayListMultimap searchCriteria = ArrayListMultimap.create();
            if (inviteeIds != null && !inviteeIds.isEmpty()) {
                searchCriteria.putAll((Object)"invitee.id", inviteeIds);
            }
            if (invitorIds != null && !invitorIds.isEmpty()) {
                searchCriteria.putAll((Object)"invitor.id", invitorIds);
            }
            return this.delegate.search((Multimap)searchCriteria, SortCriteria.NONE, page, (HttpContext)new BasicHttpContext());
        }

        @Override
        @Nonnull
        public CheckedFuture<Void, ServiceException> accept(@Nonnull @NotEmpty String inviteId, @Nonnull @NotEmpty String createdPersonId) {
            return this.delegate.accept(inviteId, createdPersonId, (HttpContext)new BasicHttpContext());
        }
    }

    public static interface PersonInvitationClient {
        @Nonnull
        public CheckedFuture<PersonInvitation, ServiceException> get(@Nonnull @NotEmpty String var1);

        @Nonnull
        public CheckedFuture<PersonInvitation, ServiceException> add(@Nonnull PersonInvitation var1);

        @Nonnull
        public CheckedFuture<PersonInvitation, ServiceException> delete(@Nonnull @NotEmpty String var1);

        @Nonnull
        public CheckedFuture<List<PersonInvitation>, ServiceException> search(List<String> var1, List<String> var2, @Nonnull Page var3);

        @Nonnull
        public CheckedFuture<Void, ServiceException> accept(@Nonnull @NotEmpty String var1, @Nonnull @NotEmpty String var2);
    }
}

